/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.services.persondir.support.jdbc;

import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang.Validate;
import org.jasig.services.persondir.support.AbstractQueryPersonAttributeDao;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJdbcPersonAttributeDao
extends AbstractQueryPersonAttributeDao {
    private final SimpleJdbcTemplate simpleJdbcTemplate;
    private final String sql;

    public AbstractJdbcPersonAttributeDao(DataSource ds, String sql) {
        Validate.notNull((Object)ds, (String)"DataSource can not be null");
        Validate.notNull((Object)sql, (String)"sql can not be null");
        this.simpleJdbcTemplate = new SimpleJdbcTemplate(ds);
        this.sql = sql;
    }

    protected String getSql() {
        return this.sql;
    }

    protected abstract Map<String, List<Object>> parseAttributeMapFromResults(List<Map<String, Object>> var1);

    @Override
    protected final Map<String, List<Object>> getUserAttributesIfNeeded(Object[] args) {
        List queryResults = this.simpleJdbcTemplate.queryForList(this.sql, args);
        return this.parseAttributeMapFromResults(queryResults);
    }
}

