/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.services.persondir.support;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.jasig.services.persondir.IPersonAttributeDao;
import org.jasig.services.persondir.support.AbstractDefaultAttributePersonAttributeDao;
import org.jasig.services.persondir.support.merger.IAttributeMerger;
import org.jasig.services.persondir.support.merger.MultivaluedAttributeMerger;
import org.springframework.beans.factory.annotation.Required;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAggregatingDefaultQueryPersonAttributeDao
extends AbstractDefaultAttributePersonAttributeDao {
    protected List<IPersonAttributeDao> personAttributeDaos;
    protected IAttributeMerger attrMerger = new MultivaluedAttributeMerger();
    protected boolean recoverExceptions = true;

    public final Map<String, List<Object>> getMultivaluedUserAttributes(Map<String, List<Object>> seed) {
        Validate.notNull(seed, (String)"seed may not be null.");
        if (this.personAttributeDaos == null) {
            throw new IllegalStateException("personAttributeDaos property must be set");
        }
        Map<Object, Object> resultAttributes = null;
        boolean isFirstQuery = true;
        for (IPersonAttributeDao currentlyConsidering : this.personAttributeDaos) {
            HashMap<String, List<Object>> currentAttributes = new HashMap();
            try {
                currentAttributes = this.getAttributesFromDao(seed, isFirstQuery, currentlyConsidering, resultAttributes);
                isFirstQuery = false;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Retrieved attributes='" + currentAttributes + "' for seed='" + seed + "', isFirstQuery=" + isFirstQuery + ", currentlyConsidering='" + currentlyConsidering + "', resultAttributes='" + resultAttributes + "'"));
                }
            }
            catch (RuntimeException rte) {
                if (this.recoverExceptions) {
                    this.logger.warn((Object)("Recovering From Exception thrown by '" + currentlyConsidering + "'"), (Throwable)rte);
                }
                this.logger.error((Object)("Failing From Exception thrown by '" + currentlyConsidering + "'"), (Throwable)rte);
                throw rte;
            }
            if (resultAttributes == null) {
                resultAttributes = currentAttributes;
                continue;
            }
            if (currentAttributes == null) continue;
            resultAttributes = this.attrMerger.mergeAttributes(resultAttributes, currentAttributes);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Aggregated attributes '" + resultAttributes + "' for seed='" + seed + "'"));
        }
        return resultAttributes;
    }

    protected abstract Map<String, List<Object>> getAttributesFromDao(Map<String, List<Object>> var1, boolean var2, IPersonAttributeDao var3, Map<String, List<Object>> var4);

    public final Set<String> getPossibleUserAttributeNames() {
        HashSet attrNames = new HashSet();
        for (IPersonAttributeDao currentDao : this.personAttributeDaos) {
            Set currentDaoAttrNames = null;
            try {
                currentDaoAttrNames = currentDao.getPossibleUserAttributeNames();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Retrieved possible attribute names '" + currentDaoAttrNames + "' from '" + currentDao + "'"));
                }
            }
            catch (RuntimeException rte) {
                if (this.recoverExceptions) {
                    this.logger.warn((Object)("Recovering From Exception thrown by '" + currentDao + "'"), (Throwable)rte);
                }
                this.logger.error((Object)("Failing From Exception thrown by '" + currentDao + "'"), (Throwable)rte);
                throw rte;
            }
            if (currentDaoAttrNames == null) continue;
            attrNames.addAll(currentDaoAttrNames);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Aggregated possible attribute names '" + attrNames + "'"));
        }
        return Collections.unmodifiableSet(attrNames);
    }

    public final IAttributeMerger getMerger() {
        return this.attrMerger;
    }

    public final void setMerger(IAttributeMerger merger) {
        Validate.notNull((Object)merger, (String)"The IAttributeMerger cannot be null");
        this.attrMerger = merger;
    }

    public final List<IPersonAttributeDao> getPersonAttributeDaos() {
        return this.personAttributeDaos;
    }

    @Required
    public final void setPersonAttributeDaos(List<IPersonAttributeDao> daos) {
        Validate.notNull(daos, (String)"The IPersonAttributeDao List cannot be null");
        this.personAttributeDaos = Collections.unmodifiableList(daos);
    }

    public final boolean isRecoverExceptions() {
        return this.recoverExceptions;
    }

    public final void setRecoverExceptions(boolean recover) {
        this.recoverExceptions = recover;
    }
}

