/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.adaptors.x509.authentication.principal;

import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Comparator;
import org.inspektr.common.ioc.annotation.NotNull;
import org.jasig.cas.adaptors.x509.authentication.principal.AbstractX509CertificateCredentialsToPrincipalResolver;

public final class X509CertificateCredentialsToIdentifierPrincipalResolver
extends AbstractX509CertificateCredentialsToPrincipalResolver {
    private static final String DEFAULT_IDENTIFIER = "$OU $CN";
    private static final String ENTRIES_DELIMITER = ",";
    private static final String NAME_VALUE_PAIR_DELIMITER = "=";
    @NotNull
    private String identifier = "$OU $CN";

    protected String resolvePrincipalInternal(X509Certificate certificate) {
        String username = this.identifier;
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Creating principal for: " + certificate.getSubjectDN().getName()));
        }
        String[] entries = certificate.getSubjectDN().getName().split(ENTRIES_DELIMITER);
        Arrays.sort(entries, new LengthComparator());
        for (String val : entries) {
            String[] nameValuePair = val.split(NAME_VALUE_PAIR_DELIMITER);
            String name = nameValuePair[0].trim();
            String value = nameValuePair[1];
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Parsed " + name + " - " + value));
            }
            username = username.replaceAll("\\$" + name, value);
        }
        if (this.identifier.equals(username)) {
            return null;
        }
        return username;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    class LengthComparator
    implements Comparator {
        LengthComparator() {
        }

        public int compare(Object o1, Object o2) {
            int len2;
            String s1 = (String)o1;
            String s2 = (String)o2;
            String[] nameValuePair1 = s1.split(X509CertificateCredentialsToIdentifierPrincipalResolver.NAME_VALUE_PAIR_DELIMITER);
            String name1 = nameValuePair1[0].trim();
            String[] nameValuePair2 = s2.split(X509CertificateCredentialsToIdentifierPrincipalResolver.NAME_VALUE_PAIR_DELIMITER);
            String name2 = nameValuePair2[0].trim();
            int len1 = name1.length();
            if (len1 > (len2 = name2.length())) {
                return -1;
            }
            if (len2 > len1) {
                return 1;
            }
            return 0;
        }
    }
}

