/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.adaptors.x509.authentication.handler.support;

import java.security.Principal;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.inspektr.common.ioc.annotation.NotNull;
import org.jasig.cas.adaptors.x509.authentication.principal.X509CertificateCredentials;
import org.jasig.cas.authentication.handler.AuthenticationException;
import org.jasig.cas.authentication.handler.support.AbstractPreAndPostProcessingAuthenticationHandler;
import org.jasig.cas.authentication.principal.Credentials;

public class X509CredentialsAuthenticationHandler
extends AbstractPreAndPostProcessingAuthenticationHandler {
    private static final int DEFAULT_MAXPATHLENGTH = 1;
    private static final boolean DEFAULT_MAXPATHLENGTH_ALLOW_UNSPECIFIED = false;
    private static final boolean DEFAULT_CHECK_KEYUSAGE = false;
    private static final boolean DEFAULT_REQUIRE_KEYUSAGE = false;
    private static final Pattern DEFAULT_SUBJECT_DN_PATTERN = Pattern.compile(".*");
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    @NotNull
    private Pattern regExTrustedIssuerDnPattern;
    private int maxPathLength = 1;
    private boolean maxPathLength_allowUnspecified = false;
    private boolean checkKeyUsage = false;
    private boolean requireKeyUsage = false;
    @NotNull
    private Pattern regExSubjectDnPattern = DEFAULT_SUBJECT_DN_PATTERN;

    protected final boolean doAuthentication(Credentials credentials) throws AuthenticationException {
        X509CertificateCredentials x509Credentials = (X509CertificateCredentials)credentials;
        X509Certificate[] certificates = x509Credentials.getCertificates();
        X509Certificate certificateCredentialsCandidate = null;
        boolean hasTrustedIssuerInChain = false;
        for (int i = certificates.length - 1; i >= 0; --i) {
            X509Certificate certificate = certificates[i];
            try {
                int pathLength;
                Principal issuerPrincipal = certificate.getIssuerDN();
                boolean isEndUserCertificate = false;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("--examining cert[" + certificate.getSerialNumber().toString() + "] " + certificate.getSubjectDN() + "\"" + " from issuer \"" + issuerPrincipal.getName() + "\""));
                }
                certificate.checkValidity();
                this.log.debug((Object)"certificate is valid");
                if (this.isCertificateFromTrustedIssuer(issuerPrincipal)) {
                    hasTrustedIssuerInChain = true;
                    this.log.debug((Object)"certificate was issued by trusted issuer");
                }
                if ((pathLength = certificate.getBasicConstraints()) != -1) {
                    this.log.debug((Object)"this is a CA certificate");
                    if (pathLength == Integer.MAX_VALUE && !this.maxPathLength_allowUnspecified) {
                        if (this.log.isWarnEnabled()) {
                            this.log.warn((Object)"authentication failed; cert pathLength not specified and unlimited/unspecified not allowed by config [see maxPathLength_allow_unlimited]");
                        }
                        return false;
                    }
                    if (pathLength > this.maxPathLength && pathLength < Integer.MAX_VALUE) {
                        if (this.log.isWarnEnabled()) {
                            this.log.warn((Object)("authentication failed; cert pathLength [" + pathLength + "] is more than allowed by config [" + this.maxPathLength + "]"));
                        }
                        return false;
                    }
                } else {
                    isEndUserCertificate = true;
                    this.log.debug((Object)"this is an end-user certificate");
                }
                if (issuerPrincipal == null || !isEndUserCertificate || !this.doesCertificateSubjectDnMatchPattern(certificate.getSubjectDN()) || this.checkKeyUsage && (!this.checkKeyUsage || !this.doesCertificateKeyUsageMatch(certificate))) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("cert[" + certificate.getSerialNumber().toString() + "] ok, setting as credentials candidate"));
                }
                certificateCredentialsCandidate = certificate;
                continue;
            }
            catch (CertificateExpiredException e) {
                this.log.warn((Object)("authentication failed; certficiate expired [" + certificate.toString() + "]"));
                certificateCredentialsCandidate = null;
                continue;
            }
            catch (CertificateNotYetValidException e) {
                this.log.warn((Object)("authentication failed; certficate not yet valid [" + certificate.toString() + "]"));
                certificateCredentialsCandidate = null;
            }
        }
        if (certificateCredentialsCandidate != null && hasTrustedIssuerInChain) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("authentication OK; SSL client authentication data meets criteria for cert[" + certificateCredentialsCandidate.getSerialNumber().toString() + "]"));
            }
            x509Credentials.setCertificate(certificateCredentialsCandidate);
            return true;
        }
        if (this.log.isInfoEnabled()) {
            if (!hasTrustedIssuerInChain) {
                this.log.info((Object)("client cert did not have trusted issuer pattern \"" + this.regExTrustedIssuerDnPattern.pattern() + "\" in chain; authentication failed"));
            } else {
                this.log.info((Object)"authentication failed; SSL client authentication data doesn't meet criteria");
            }
        }
        return false;
    }

    public void setTrustedIssuerDnPattern(String trustedIssuerDnPattern) {
        this.regExTrustedIssuerDnPattern = Pattern.compile(trustedIssuerDnPattern);
    }

    public void setMaxPathLength(int maxPathLength) {
        this.maxPathLength = maxPathLength;
    }

    public void setMaxPathLengthAllowUnspecified(boolean maxPathLength_allowUnspecified) {
        this.maxPathLength_allowUnspecified = maxPathLength_allowUnspecified;
    }

    public void setCheckKeyUsage(boolean checkKeyUsage) {
        this.checkKeyUsage = checkKeyUsage;
    }

    public void setRequireKeyUsage(boolean requireKeyUsage) {
        this.requireKeyUsage = requireKeyUsage;
    }

    public void setSubjectDnPattern(String subjectDnPattern) {
        this.regExSubjectDnPattern = Pattern.compile(subjectDnPattern);
    }

    private boolean doesCertificateKeyUsageMatch(X509Certificate certificate) {
        String extensionOID = "2.5.29.15";
        boolean[] keyUsage = certificate.getKeyUsage();
        if (keyUsage == null) {
            this.log.warn((Object)("isKeyUsageRequired?: " + this.requireKeyUsage + "; keyUsage not found."));
            return !this.requireKeyUsage;
        }
        this.log.debug((Object)"keyUsage extension found: examing...");
        if (!this.isExtensionMarkedCritical(certificate, "2.5.29.15") && !this.requireKeyUsage) {
            this.log.debug((Object)"match ok; keyUsage extension not critical and not required so not checked");
            return true;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("extension is marked critical in cert OR required by config[critical=" + this.isExtensionMarkedCritical(certificate, "2.5.29.15") + ";required=" + this.requireKeyUsage + "]"));
        }
        if (keyUsage[0]) {
            this.log.debug((Object)"match ok; keyUsage extension OK");
            return true;
        }
        if (this.log.isWarnEnabled() && this.requireKeyUsage) {
            this.log.warn((Object)("match error; required/critical keyUsage extension fails[critical=" + this.isExtensionMarkedCritical(certificate, "2.5.29.15") + ";required=" + this.requireKeyUsage + "]"));
        }
        return false;
    }

    private boolean isExtensionMarkedCritical(X509Certificate certificate, String oid) {
        Set<String> criticalOids = certificate.getCriticalExtensionOIDs();
        if (criticalOids == null || criticalOids.isEmpty()) {
            return false;
        }
        return criticalOids.contains(oid);
    }

    private boolean doesCertificateSubjectDnMatchPattern(Principal principal) {
        return this.doesNameMatchPattern(principal, this.regExSubjectDnPattern);
    }

    private boolean isCertificateFromTrustedIssuer(Principal principal) {
        return this.doesNameMatchPattern(principal, this.regExTrustedIssuerDnPattern);
    }

    private boolean doesNameMatchPattern(Principal principal, Pattern pattern) {
        boolean result = pattern.matcher(principal.getName()).matches();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Pattern Match: " + result + " [" + principal.getName() + "] against [" + pattern.pattern() + "]."));
        }
        return result;
    }

    public boolean supports(Credentials credentials) {
        return credentials != null && X509CertificateCredentials.class.isAssignableFrom(credentials.getClass());
    }
}

