/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.openid.authentication.handler.support;

import org.inspektr.common.ioc.annotation.NotNull;
import org.jasig.cas.authentication.handler.AuthenticationException;
import org.jasig.cas.authentication.handler.AuthenticationHandler;
import org.jasig.cas.authentication.principal.Credentials;
import org.jasig.cas.support.openid.authentication.principal.OpenIdCredentials;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.registry.TicketRegistry;

public final class OpenIdCredentialsAuthenticationHandler
implements AuthenticationHandler {
    @NotNull
    private TicketRegistry ticketRegistry;

    public boolean authenticate(Credentials credentials) throws AuthenticationException {
        OpenIdCredentials c = (OpenIdCredentials)credentials;
        TicketGrantingTicket t = (TicketGrantingTicket)this.ticketRegistry.getTicket(c.getTicketGrantingTicketId(), TicketGrantingTicket.class);
        if (t.isExpired()) {
            return false;
        }
        return t.getAuthentication().getPrincipal().getId().equals(c.getUsername());
    }

    public boolean supports(Credentials credentials) {
        return credentials instanceof OpenIdCredentials;
    }

    public void setTicketRegistry(TicketRegistry ticketRegistry) {
        this.ticketRegistry = ticketRegistry;
    }
}

