/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.flow;

import org.inspektr.common.ioc.annotation.NotNull;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.authentication.principal.WebApplicationService;
import org.jasig.cas.ticket.TicketException;
import org.jasig.cas.web.support.WebUtils;
import org.springframework.util.StringUtils;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public final class GenerateServiceTicketAction
extends AbstractAction {
    @NotNull
    private CentralAuthenticationService centralAuthenticationService;

    protected Event doExecute(RequestContext context) {
        WebApplicationService service = WebUtils.getService(context);
        String ticketGrantingTicket = WebUtils.getTicketGrantingTicketId(context);
        try {
            String serviceTicketId = this.centralAuthenticationService.grantServiceTicket(ticketGrantingTicket, service);
            WebUtils.putServiceTicketInRequestScope(context, serviceTicketId);
            return this.success();
        }
        catch (TicketException e) {
            if (this.isGatewayPresent(context)) {
                return this.result("gateway");
            }
            return this.error();
        }
    }

    public void setCentralAuthenticationService(CentralAuthenticationService centralAuthenticationService) {
        this.centralAuthenticationService = centralAuthenticationService;
    }

    protected boolean isGatewayPresent(RequestContext context) {
        return StringUtils.hasText((String)context.getExternalContext().getRequestParameterMap().get("gateway"));
    }
}

