/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManagerFactory;
import org.inspektr.common.ioc.annotation.NotNull;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.ServiceTicketImpl;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketGrantingTicketImpl;
import org.jasig.cas.ticket.registry.AbstractDistributedTicketRegistry;
import org.springframework.orm.jpa.JpaTemplate;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JpaTicketRegistry
extends AbstractDistributedTicketRegistry {
    @NotNull
    private JpaTemplate jpaTemplate;
    @NotNull
    private String ticketGrantingTicketPrefix = "TGT";

    public JpaTicketRegistry(EntityManagerFactory factory) {
        this.jpaTemplate = new JpaTemplate(factory);
    }

    @Override
    protected void updateTicket(Ticket ticket) {
        this.jpaTemplate.merge((Object)ticket);
    }

    @Override
    public void addTicket(Ticket ticket) {
        this.jpaTemplate.persist((Object)ticket);
    }

    @Override
    @Transactional(readOnly=false)
    public boolean deleteTicket(String ticketId) {
        Ticket ticket = this.getRawTicket(ticketId);
        if (ticket == null) {
            return false;
        }
        if (ticket instanceof ServiceTicket) {
            this.removeTicket(ticket);
            return true;
        }
        this.deleteTicketAndChildren(ticket);
        return true;
    }

    private void deleteTicketAndChildren(Ticket ticket) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", ticket.getId());
        List ticketGrantingTicketImpls = this.jpaTemplate.findByNamedParams("select t from TicketGrantingTicketImpl t where t.ticketGrantingTicket.id = :id", params);
        List serviceTicketImpls = this.jpaTemplate.findByNamedParams("select s from ServiceTicketImpl s where s.ticketGrantingTicket.id = :id", params);
        for (ServiceTicketImpl s : serviceTicketImpls) {
            this.removeTicket(s);
        }
        for (TicketGrantingTicketImpl t : ticketGrantingTicketImpls) {
            this.deleteTicketAndChildren(t);
        }
        this.removeTicket(ticket);
    }

    private void removeTicket(Ticket ticket) {
        try {
            if (this.log.isDebugEnabled()) {
                Date creationDate = new Date(ticket.getCreationTime());
                this.log.debug((Object)("Removing Ticket >" + ticket.getId() + "< created: " + creationDate.toString()));
            }
            this.jpaTemplate.remove((Object)ticket);
        }
        catch (Exception e) {
            this.log.error((Object)("Error removing " + ticket + " from registry."), (Throwable)e);
        }
    }

    @Override
    public Ticket getTicket(String ticketId) {
        return this.getProxiedTicketInstance(this.getRawTicket(ticketId));
    }

    private Ticket getRawTicket(String ticketId) {
        try {
            if (ticketId.startsWith(this.ticketGrantingTicketPrefix)) {
                return (Ticket)this.jpaTemplate.find(TicketGrantingTicketImpl.class, (Object)ticketId);
            }
            return (Ticket)this.jpaTemplate.find(ServiceTicketImpl.class, (Object)ticketId);
        }
        catch (Exception e) {
            this.log.error((Object)("Error getting ticket " + ticketId + " from registry."), (Throwable)e);
            return null;
        }
    }

    @Override
    @Transactional(readOnly=true)
    public Collection<Ticket> getTickets() {
        List tgts = this.jpaTemplate.find("select t from TicketGrantingTicketImpl t");
        List sts = this.jpaTemplate.find("select s from ServiceTicketImpl s");
        ArrayList<Ticket> tickets = new ArrayList<Ticket>();
        tickets.addAll(tgts);
        tickets.addAll(sts);
        return tickets;
    }

    public void setTicketGrantingTicketPrefix(String ticketGrantingTicketPrefix) {
        this.ticketGrantingTicketPrefix = ticketGrantingTicketPrefix;
    }
}

