/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.registry;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.registry.AbstractTicketRegistry;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultTicketRegistry
extends AbstractTicketRegistry {
    private final Map<String, Ticket> cache;

    public DefaultTicketRegistry() {
        this.cache = new ConcurrentHashMap<String, Ticket>();
    }

    public DefaultTicketRegistry(int initialCapacity, float loadFactor, int concurrencyLevel) {
        this.cache = new ConcurrentHashMap<String, Ticket>(initialCapacity, loadFactor, concurrencyLevel);
    }

    @Override
    public void addTicket(Ticket ticket) {
        Assert.notNull((Object)ticket, (String)"ticket cannot be null");
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Added ticket [" + ticket.getId() + "] to registry."));
        }
        this.cache.put(ticket.getId(), ticket);
    }

    @Override
    public Ticket getTicket(String ticketId) {
        Ticket ticket;
        if (ticketId == null) {
            return null;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Attempting to retrieve ticket [" + ticketId + "]"));
        }
        if ((ticket = this.cache.get(ticketId)) != null) {
            this.log.debug((Object)("Ticket [" + ticketId + "] found in registry."));
        }
        return ticket;
    }

    @Override
    public boolean deleteTicket(String ticketId) {
        if (ticketId == null) {
            return false;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Removing ticket [" + ticketId + "] from registry"));
        }
        return this.cache.remove(ticketId) != null;
    }

    @Override
    public Collection<Ticket> getTickets() {
        return Collections.unmodifiableCollection(this.cache.values());
    }
}

