/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.principal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.inspektr.common.ioc.annotation.NotNull;
import org.jasig.cas.authentication.principal.Credentials;
import org.jasig.cas.authentication.principal.CredentialsToPrincipalResolver;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.SimplePrincipal;
import org.jasig.services.persondir.IPersonAttributeDao;
import org.jasig.services.persondir.support.StubPersonAttributeDao;

public abstract class AbstractPersonDirectoryCredentialsToPrincipalResolver
implements CredentialsToPrincipalResolver {
    protected final Log log = LogFactory.getLog(this.getClass());
    private boolean returnNullIfNoAttributes = false;
    @NotNull
    private IPersonAttributeDao attributeRepository = new StubPersonAttributeDao(new HashMap());

    public final Principal resolvePrincipal(Credentials credentials) {
        Map attributes;
        String principalId;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Attempting to resolve a principal...");
        }
        if ((principalId = this.extractPrincipalId(credentials)) == null) {
            return null;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Creating SimplePrincipal for [" + principalId + "]"));
        }
        if ((attributes = this.attributeRepository.getMultivaluedUserAttributes(principalId)) == null & !this.returnNullIfNoAttributes) {
            return new SimplePrincipal(principalId);
        }
        if (attributes == null && this.returnNullIfNoAttributes) {
            return null;
        }
        HashMap<String, Object> convertedAttributes = new HashMap<String, Object>();
        for (Map.Entry entry : attributes.entrySet()) {
            String key = (String)entry.getKey();
            Object value = ((List)entry.getValue()).size() == 1 ? ((List)entry.getValue()).get(0) : entry.getValue();
            convertedAttributes.put(key, value);
        }
        return new SimplePrincipal(principalId, convertedAttributes);
    }

    protected abstract String extractPrincipalId(Credentials var1);

    public final void setAttributeRepository(IPersonAttributeDao attributeRepository) {
        this.attributeRepository = attributeRepository;
    }

    public void setReturnNullIfNoAttributes(boolean returnNullIfNoAttributes) {
        this.returnNullIfNoAttributes = returnNullIfNoAttributes;
    }
}

