/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication;

import java.util.Map;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.principal.Principal;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAuthentication
implements Authentication {
    private final Principal principal;
    private final Map<String, Object> attributes;

    public AbstractAuthentication(Principal principal, Map<String, Object> attributes) {
        Assert.notNull((Object)principal, (String)"principal cannot be null");
        Assert.notNull(attributes, (String)"attributes cannot be null");
        this.principal = principal;
        this.attributes = attributes;
    }

    @Override
    public final Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public final Principal getPrincipal() {
        return this.principal;
    }

    public final boolean equals(Object o) {
        if (o == null || !this.getClass().isAssignableFrom(o.getClass())) {
            return false;
        }
        Authentication a = (Authentication)o;
        return this.principal.equals(a.getPrincipal()) && this.getAuthenticatedDate().equals(a.getAuthenticatedDate()) && ((Object)this.attributes).equals(a.getAttributes());
    }

    public final int hashCode() {
        return 49 * this.principal.hashCode() ^ this.getAuthenticatedDate().hashCode();
    }

    public final String toString() {
        return "[Principal=" + this.principal.getId() + ", attributes=" + this.attributes.toString() + "]";
    }
}

