/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.inspektr.audit.annotation.Auditable;
import org.inspektr.audit.spi.support.DefaultAuditableActionResolver;
import org.inspektr.audit.spi.support.ObjectCreationAuditableActionResolver;
import org.inspektr.audit.spi.support.ReturnValueAsStringResourceResolver;
import org.inspektr.common.ioc.annotation.NotNull;
import org.inspektr.statistics.annotation.Statistic;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.audit.spi.ServiceResourceResolver;
import org.jasig.cas.audit.spi.TicketAsFirstParameterResourceResolver;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.AuthenticationManager;
import org.jasig.cas.authentication.MutableAuthentication;
import org.jasig.cas.authentication.handler.AuthenticationException;
import org.jasig.cas.authentication.principal.Credentials;
import org.jasig.cas.authentication.principal.PersistentIdGenerator;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.ShibbolethCompatiblePersistentIdGenerator;
import org.jasig.cas.authentication.principal.SimplePrincipal;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.ServicesManager;
import org.jasig.cas.services.UnauthorizedProxyingException;
import org.jasig.cas.services.UnauthorizedServiceException;
import org.jasig.cas.services.UnauthorizedSsoServiceException;
import org.jasig.cas.ticket.ExpirationPolicy;
import org.jasig.cas.ticket.InvalidTicketException;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.TicketCreationException;
import org.jasig.cas.ticket.TicketException;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.TicketGrantingTicketImpl;
import org.jasig.cas.ticket.TicketValidationException;
import org.jasig.cas.ticket.registry.TicketRegistry;
import org.jasig.cas.util.UniqueTicketIdGenerator;
import org.jasig.cas.validation.Assertion;
import org.jasig.cas.validation.ImmutableAssertionImpl;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CentralAuthenticationServiceImpl
implements CentralAuthenticationService {
    private final Log log = LogFactory.getLog(this.getClass());
    @NotNull
    private TicketRegistry ticketRegistry;
    @NotNull
    private TicketRegistry serviceTicketRegistry;
    @NotNull
    private AuthenticationManager authenticationManager;
    @NotNull
    private UniqueTicketIdGenerator ticketGrantingTicketUniqueTicketIdGenerator;
    @NotNull
    private Map<String, UniqueTicketIdGenerator> uniqueTicketIdGeneratorsForService;
    @NotNull
    private ExpirationPolicy ticketGrantingTicketExpirationPolicy;
    @NotNull
    private ExpirationPolicy serviceTicketExpirationPolicy;
    @NotNull
    private ServicesManager servicesManager;
    @NotNull
    private PersistentIdGenerator persistentIdGenerator = new ShibbolethCompatiblePersistentIdGenerator();

    @Override
    @Auditable(action="TICKET_GRANTING_TICKET_DESTROYED", actionResolverClass=DefaultAuditableActionResolver.class, resourceResolverClass=TicketAsFirstParameterResourceResolver.class)
    @Statistic(name="DESTROY_TICKET_GRANTING_TICKET", requiredPrecision={Statistic.Precision.DAY, Statistic.Precision.MINUTE, Statistic.Precision.HOUR})
    @Transactional(readOnly=false)
    public void destroyTicketGrantingTicket(String ticketGrantingTicketId) {
        TicketGrantingTicket ticket;
        Assert.notNull((Object)ticketGrantingTicketId);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Removing ticket [" + ticketGrantingTicketId + "] from registry."));
        }
        if ((ticket = (TicketGrantingTicket)this.ticketRegistry.getTicket(ticketGrantingTicketId, TicketGrantingTicket.class)) == null) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Ticket found.  Expiring and then deleting.");
        }
        ticket.expire();
        this.ticketRegistry.deleteTicket(ticketGrantingTicketId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Auditable(action="SERVICE_TICKET", successSuffix="_CREATED", failureSuffix="_NOT_CREATED", actionResolverClass=ObjectCreationAuditableActionResolver.class, resourceResolverClass=ServiceResourceResolver.class)
    @Statistic(name="GRANT_SERVICE_TICKET", requiredPrecision={Statistic.Precision.DAY, Statistic.Precision.MINUTE, Statistic.Precision.HOUR})
    @Transactional(readOnly=false)
    public String grantServiceTicket(String ticketGrantingTicketId, Service service, Credentials credentials) throws TicketException {
        Assert.notNull((Object)ticketGrantingTicketId, (String)"ticketGrantingticketId cannot be null");
        Assert.notNull((Object)service, (String)"service cannot be null");
        TicketGrantingTicket ticketGrantingTicket = (TicketGrantingTicket)this.ticketRegistry.getTicket(ticketGrantingTicketId, TicketGrantingTicket.class);
        if (ticketGrantingTicket == null) {
            throw new InvalidTicketException();
        }
        TicketGrantingTicket ticketGrantingTicket2 = ticketGrantingTicket;
        synchronized (ticketGrantingTicket2) {
            if (ticketGrantingTicket.isExpired()) {
                this.ticketRegistry.deleteTicket(ticketGrantingTicketId);
                throw new InvalidTicketException();
            }
        }
        RegisteredService registeredService = this.servicesManager.findServiceBy(service);
        if (registeredService == null || !registeredService.isEnabled()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Service [" + service.getId() + "] not found in ServiceRegistry."));
            }
            throw new UnauthorizedServiceException();
        }
        if (!registeredService.isSsoEnabled() && credentials == null && ticketGrantingTicket.getCountOfUses() > 0) {
            throw new UnauthorizedSsoServiceException();
        }
        if (credentials != null) {
            try {
                Authentication authentication = this.authenticationManager.authenticate(credentials);
                Authentication originalAuthentication = ticketGrantingTicket.getAuthentication();
                if (!authentication.getPrincipal().equals(originalAuthentication.getPrincipal()) || !((Object)authentication.getAttributes()).equals(originalAuthentication.getAttributes())) {
                    throw new TicketCreationException();
                }
            }
            catch (AuthenticationException e) {
                throw new TicketCreationException(e);
            }
        }
        UniqueTicketIdGenerator serviceTicketUniqueTicketIdGenerator = this.uniqueTicketIdGeneratorsForService.get(service.getClass().getName());
        ServiceTicket serviceTicket = ticketGrantingTicket.grantServiceTicket(serviceTicketUniqueTicketIdGenerator.getNewTicketId("ST"), service, this.serviceTicketExpirationPolicy, credentials != null);
        this.serviceTicketRegistry.addTicket(serviceTicket);
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Granted service ticket [" + serviceTicket.getId() + "] for service [" + service.getId() + "] for user [" + serviceTicket.getGrantingTicket().getAuthentication().getPrincipal().getId() + "]"));
        }
        return serviceTicket.getId();
    }

    @Override
    @Auditable(action="SERVICE_TICKET", successSuffix="_CREATED", failureSuffix="_NOT_CREATED", actionResolverClass=ObjectCreationAuditableActionResolver.class, resourceResolverClass=ServiceResourceResolver.class)
    @Statistic(name="GRANT_SERVICE_TICKET", requiredPrecision={Statistic.Precision.DAY, Statistic.Precision.MINUTE, Statistic.Precision.HOUR})
    @Transactional(readOnly=false)
    public String grantServiceTicket(String ticketGrantingTicketId, Service service) throws TicketException {
        return this.grantServiceTicket(ticketGrantingTicketId, service, null);
    }

    @Override
    @Auditable(action="PROXY_GRANTING_TICKET", successSuffix="_CREATED", failureSuffix="_NOT_CREATED", actionResolverClass=ObjectCreationAuditableActionResolver.class, resourceResolverClass=ReturnValueAsStringResourceResolver.class)
    @Statistic(name="GRANT_PROXY_TICKET", requiredPrecision={Statistic.Precision.DAY, Statistic.Precision.MINUTE, Statistic.Precision.HOUR})
    @Transactional(readOnly=false)
    public String delegateTicketGrantingTicket(String serviceTicketId, Credentials credentials) throws TicketException {
        Assert.notNull((Object)serviceTicketId, (String)"serviceTicketId cannot be null");
        Assert.notNull((Object)credentials, (String)"credentials cannot be null");
        try {
            Authentication authentication = this.authenticationManager.authenticate(credentials);
            ServiceTicket serviceTicket = (ServiceTicket)this.serviceTicketRegistry.getTicket(serviceTicketId, ServiceTicket.class);
            if (serviceTicket == null || serviceTicket.isExpired()) {
                throw new InvalidTicketException();
            }
            RegisteredService registeredService = this.servicesManager.findServiceBy(serviceTicket.getService());
            if (registeredService == null || !registeredService.isEnabled() || !registeredService.isAllowedToProxy()) {
                throw new UnauthorizedProxyingException();
            }
            TicketGrantingTicket ticketGrantingTicket = serviceTicket.grantTicketGrantingTicket(this.ticketGrantingTicketUniqueTicketIdGenerator.getNewTicketId("TGT"), authentication, this.ticketGrantingTicketExpirationPolicy);
            this.ticketRegistry.addTicket(ticketGrantingTicket);
            return ticketGrantingTicket.getId();
        }
        catch (AuthenticationException e) {
            throw new TicketCreationException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Auditable(action="SERVICE_TICKET_VALIDATE", successSuffix="D", failureSuffix="_FAILED", actionResolverClass=ObjectCreationAuditableActionResolver.class, resourceResolverClass=TicketAsFirstParameterResourceResolver.class)
    @Statistic(name="SERVICE_TICKET_VALIDATE", requiredPrecision={Statistic.Precision.DAY, Statistic.Precision.MINUTE, Statistic.Precision.HOUR})
    @Transactional(readOnly=false)
    public Assertion validateServiceTicket(String serviceTicketId, Service service) throws TicketException {
        Assert.notNull((Object)serviceTicketId, (String)"serviceTicketId cannot be null");
        Assert.notNull((Object)service, (String)"service cannot be null");
        ServiceTicket serviceTicket = (ServiceTicket)this.serviceTicketRegistry.getTicket(serviceTicketId, ServiceTicket.class);
        RegisteredService registeredService = this.servicesManager.findServiceBy(service);
        if (registeredService == null || !registeredService.isEnabled()) {
            throw new UnauthorizedServiceException("Service not allowed to validate tickets.");
        }
        if (serviceTicket == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("ServiceTicket [" + serviceTicketId + "] does not exist."));
            }
            throw new InvalidTicketException();
        }
        try {
            Authentication authToUse;
            String principalId;
            ServiceTicket serviceTicket2 = serviceTicket;
            synchronized (serviceTicket2) {
                if (serviceTicket.isExpired()) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("ServiceTicket [" + serviceTicketId + "] has expired."));
                    }
                    throw new InvalidTicketException();
                }
                if (!serviceTicket.isValidFor(service)) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error((Object)("ServiceTicket [" + serviceTicketId + "] with service [" + serviceTicket.getService().getId() + " does not match supplied service [" + service + "]"));
                    }
                    throw new TicketValidationException(serviceTicket.getService());
                }
            }
            int authenticationChainSize = serviceTicket.getGrantingTicket().getChainedAuthentications().size();
            Authentication authentication = serviceTicket.getGrantingTicket().getChainedAuthentications().get(authenticationChainSize - 1);
            Principal principal = authentication.getPrincipal();
            String string = principalId = registeredService.isAnonymousAccess() ? this.persistentIdGenerator.generate(principal, serviceTicket.getService()) : principal.getId();
            if (!registeredService.isIgnoreAttributes()) {
                HashMap<String, Object> attributes = new HashMap<String, Object>();
                for (String attribute : registeredService.getAllowedAttributes()) {
                    Object value = principal.getAttributes().get(attribute);
                    if (value == null) continue;
                    attributes.put(attribute, value);
                }
                SimplePrincipal modifiedPrincipal = new SimplePrincipal(principalId, attributes);
                MutableAuthentication mutableAuthentication = new MutableAuthentication((Principal)modifiedPrincipal, authentication.getAuthenticatedDate());
                mutableAuthentication.getAttributes().putAll(authentication.getAttributes());
                mutableAuthentication.getAuthenticatedDate().setTime(authentication.getAuthenticatedDate().getTime());
                authToUse = mutableAuthentication;
            } else {
                authToUse = authentication;
            }
            ArrayList<Authentication> authentications = new ArrayList<Authentication>();
            for (int i = 0; i < authenticationChainSize - 1; ++i) {
                authentications.add(serviceTicket.getGrantingTicket().getChainedAuthentications().get(i));
            }
            authentications.add(authToUse);
            ImmutableAssertionImpl immutableAssertionImpl = new ImmutableAssertionImpl(authentications, serviceTicket.getService(), serviceTicket.isFromNewLogin());
            return immutableAssertionImpl;
        }
        finally {
            if (serviceTicket.isExpired()) {
                this.serviceTicketRegistry.deleteTicket(serviceTicketId);
            }
        }
    }

    @Override
    @Auditable(action="TICKET_GRANTING_TICKET", successSuffix="_CREATED", failureSuffix="_NOT_CREATED", actionResolverClass=ObjectCreationAuditableActionResolver.class, resourceResolverClass=ReturnValueAsStringResourceResolver.class)
    @Statistic(name="CREATE_TICKET_GRANTING_TICKET", requiredPrecision={Statistic.Precision.DAY, Statistic.Precision.MINUTE, Statistic.Precision.HOUR})
    @Transactional(readOnly=false)
    public String createTicketGrantingTicket(Credentials credentials) throws TicketCreationException {
        Assert.notNull((Object)credentials, (String)"credentials cannot be null");
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Attempting to create TicketGrantingTicket for " + credentials));
        }
        try {
            Authentication authentication = this.authenticationManager.authenticate(credentials);
            TicketGrantingTicketImpl ticketGrantingTicket = new TicketGrantingTicketImpl(this.ticketGrantingTicketUniqueTicketIdGenerator.getNewTicketId("TGT"), authentication, this.ticketGrantingTicketExpirationPolicy);
            this.ticketRegistry.addTicket(ticketGrantingTicket);
            return ticketGrantingTicket.getId();
        }
        catch (AuthenticationException e) {
            throw new TicketCreationException(e);
        }
    }

    public void setTicketRegistry(TicketRegistry ticketRegistry) {
        this.ticketRegistry = ticketRegistry;
        if (this.serviceTicketRegistry == null) {
            this.serviceTicketRegistry = ticketRegistry;
        }
    }

    public void setServiceTicketRegistry(TicketRegistry serviceTicketRegistry) {
        this.serviceTicketRegistry = serviceTicketRegistry;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setTicketGrantingTicketExpirationPolicy(ExpirationPolicy ticketGrantingTicketExpirationPolicy) {
        this.ticketGrantingTicketExpirationPolicy = ticketGrantingTicketExpirationPolicy;
    }

    public void setTicketGrantingTicketUniqueTicketIdGenerator(UniqueTicketIdGenerator uniqueTicketIdGenerator) {
        this.ticketGrantingTicketUniqueTicketIdGenerator = uniqueTicketIdGenerator;
    }

    public void setServiceTicketExpirationPolicy(ExpirationPolicy serviceTicketExpirationPolicy) {
        this.serviceTicketExpirationPolicy = serviceTicketExpirationPolicy;
    }

    public void setUniqueTicketIdGeneratorsForService(Map<String, UniqueTicketIdGenerator> uniqueTicketIdGeneratorsForService) {
        this.uniqueTicketIdGeneratorsForService = uniqueTicketIdGeneratorsForService;
    }

    public void setServicesManager(ServicesManager servicesManager) {
        this.servicesManager = servicesManager;
    }

    public void setPersistentIdGenerator(PersistentIdGenerator persistentIdGenerator) {
        this.persistentIdGenerator = persistentIdGenerator;
    }
}

