/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.convert;

import org.springframework.core.NestedRuntimeException;

public class ConversionException
extends NestedRuntimeException {
    private Class sourceClass;
    private transient Object value;
    private Class targetClass;

    public ConversionException(Object value, Class targetClass) {
        super("Unable to convert value '" + value + "' of type '" + (value != null ? value.getClass().getName() : null) + "' to class '" + targetClass.getName() + "'");
        this.value = value;
        this.targetClass = targetClass;
    }

    public ConversionException(Object value, Class targetClass, Throwable cause) {
        super("Unable to convert value '" + value + "' of type '" + (value != null ? value.getClass().getName() : null) + "' to class '" + targetClass.getName() + "'", cause);
        this.value = value;
        this.targetClass = targetClass;
    }

    public ConversionException(Object value, Class targetClass, String message, Throwable cause) {
        super(message, cause);
        this.value = value;
        this.targetClass = targetClass;
    }

    public ConversionException(Class sourceClass, Class targetClass, String message) {
        super(message);
        this.sourceClass = sourceClass;
        this.value = null;
        this.targetClass = targetClass;
    }

    public ConversionException(Class sourceClass, String message) {
        super(message);
        this.sourceClass = sourceClass;
        this.value = null;
        this.targetClass = null;
    }

    public ConversionException(Class sourceClass, Object value, Class targetClass, String message) {
        super(message);
        this.sourceClass = sourceClass;
        this.value = value;
        this.targetClass = targetClass;
    }

    public Class getSourceClass() {
        return this.sourceClass;
    }

    public Object getValue() {
        return this.value;
    }

    public Class getTargetClass() {
        return this.targetClass;
    }
}

