/*
 * Decompiled with CFR 0.152.
 */
package org.inspektr.error.support;

import java.util.List;
import org.inspektr.common.ioc.annotation.NotEmpty;
import org.inspektr.common.ioc.annotation.NotNull;
import org.inspektr.error.ErrorLogManager;
import org.inspektr.error.ErrorReporter;
import org.inspektr.error.spi.CurrentContextPrincipalResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultErrorLogManager
implements ErrorLogManager {
    @NotNull
    private String applicationCode;
    private CurrentContextPrincipalResolver currentContextPrincipalResolver;
    @NotEmpty
    private List<ErrorReporter> errorReporters;

    public DefaultErrorLogManager(String applicationCode, List<ErrorReporter> errorReporters) {
        this.applicationCode = applicationCode;
        this.errorReporters = errorReporters;
    }

    public void setCurrentContextPrincipalResolver(CurrentContextPrincipalResolver resolver) {
        this.currentContextPrincipalResolver = resolver;
    }

    @Override
    public void recordError(String errorDescription) {
        String principal = this.resolvePrincipal();
        for (ErrorReporter r : this.errorReporters) {
            r.reportError(this.applicationCode, principal, errorDescription);
        }
    }

    @Override
    public void recordError(Throwable throwable) {
        String principal = this.resolvePrincipal();
        for (ErrorReporter r : this.errorReporters) {
            r.reportError(this.applicationCode, principal, throwable);
        }
    }

    @Override
    public List<ErrorReporter> getErrorReporters() {
        return this.errorReporters;
    }

    private String resolvePrincipal() {
        return this.currentContextPrincipalResolver == null ? null : this.currentContextPrincipalResolver.resolve();
    }
}

