/*
 * Decompiled with CFR 0.152.
 */
package org.inspektr.audit.support;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.inspektr.audit.AuditTrailManager;
import org.inspektr.audit.AuditableActionContext;
import org.inspektr.common.ioc.annotation.NotNull;
import org.springframework.jdbc.core.simple.SimpleJdbcDaoSupport;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public final class JdbcAuditTrailManager
extends SimpleJdbcDaoSupport
implements AuditTrailManager {
    private static final String INSERT_SQL_STATEMENT = "Insert into COM_AUDIT_TRAIL(AUD_USER, AUD_CLIENT_IP, AUD_SERVER_IP, AUD_RESOURCE, AUD_ACTION, APPLIC_CD, AUD_DATE) Values(?, ?, ?, ?, ?, ?, ?)";
    @NotNull
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    @NotNull
    private final TransactionTemplate transactionTemplate;

    public JdbcAuditTrailManager(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    public void record(AuditableActionContext auditableActionContext) {
        this.executorService.execute(new LoggingTask(auditableActionContext, this.transactionTemplate));
    }

    protected class LoggingTask
    implements Runnable {
        private final AuditableActionContext auditableActionContext;
        private final TransactionTemplate transactionTemplate;

        public LoggingTask(AuditableActionContext auditableActionContext, TransactionTemplate transactionTemplate) {
            this.auditableActionContext = auditableActionContext;
            this.transactionTemplate = transactionTemplate;
        }

        public void run() {
            this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus transactionStatus) {
                    String userId = LoggingTask.this.auditableActionContext.getPrincipal().length() <= 100 ? LoggingTask.this.auditableActionContext.getPrincipal() : LoggingTask.this.auditableActionContext.getPrincipal().substring(0, 100);
                    String resource = LoggingTask.this.auditableActionContext.getResourceOperatedUpon().length() <= 100 ? LoggingTask.this.auditableActionContext.getResourceOperatedUpon() : LoggingTask.this.auditableActionContext.getResourceOperatedUpon().substring(0, 100);
                    String action = LoggingTask.this.auditableActionContext.getActionPerformed().length() <= 100 ? LoggingTask.this.auditableActionContext.getActionPerformed() : LoggingTask.this.auditableActionContext.getActionPerformed().substring(0, 100);
                    JdbcAuditTrailManager.this.getSimpleJdbcTemplate().update(JdbcAuditTrailManager.INSERT_SQL_STATEMENT, new Object[]{userId, LoggingTask.this.auditableActionContext.getClientIpAddress(), LoggingTask.this.auditableActionContext.getServerIpAddress(), resource, action, LoggingTask.this.auditableActionContext.getApplicationCode(), LoggingTask.this.auditableActionContext.getWhenActionWasPerformed()});
                }
            });
        }
    }
}

