/*
 * Decompiled with CFR 0.152.
 */
package org.inspektr.audit;

import java.util.Date;
import org.springframework.util.Assert;

public final class AuditableActionContext {
    private final String principal;
    private final String resourceOperatedUpon;
    private final String actionPerformed;
    private final String applicationCode;
    private final Date whenActionWasPerformed;
    private final String clientIpAddress;
    private final String serverIpAddress;

    public AuditableActionContext(String principal, String resourceOperatedUpon, String actionPerformed, String applicationCode, Date whenActionWasPerformed, String clientIpAddress, String serverIpAddress) {
        Assert.notNull((Object)principal, (String)"principal cannot be null");
        Assert.notNull((Object)resourceOperatedUpon, (String)"resourceOperatedUpon cannot be null");
        Assert.notNull((Object)actionPerformed, (String)"actionPerformed cannot be null.");
        Assert.notNull((Object)applicationCode, (String)"applicationCode cannot be null.");
        Assert.notNull((Object)whenActionWasPerformed, (String)"whenActionPerformed cannot be null.");
        Assert.notNull((Object)clientIpAddress, (String)"clientIpAddress cannot be null.");
        Assert.notNull((Object)serverIpAddress, (String)"serverIpAddress cannot be null.");
        this.principal = principal;
        this.resourceOperatedUpon = resourceOperatedUpon;
        this.actionPerformed = actionPerformed;
        this.applicationCode = applicationCode;
        this.whenActionWasPerformed = new Date(whenActionWasPerformed.getTime());
        this.clientIpAddress = clientIpAddress;
        this.serverIpAddress = serverIpAddress;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public String getResourceOperatedUpon() {
        return this.resourceOperatedUpon;
    }

    public String getActionPerformed() {
        return this.actionPerformed;
    }

    public String getApplicationCode() {
        return this.applicationCode;
    }

    public Date getWhenActionWasPerformed() {
        return new Date(this.whenActionWasPerformed.getTime());
    }

    public String getClientIpAddress() {
        return this.clientIpAddress;
    }

    public String getServerIpAddress() {
        return this.serverIpAddress;
    }
}

