/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.principal;

import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.inspektr.common.ioc.annotation.NotNull;
import org.jasig.cas.authentication.principal.AbstractLdapPersonDirectoryCredentialsToPrincipalResolver;
import org.jasig.cas.authentication.principal.Credentials;
import org.jasig.cas.authentication.principal.CredentialsToPrincipalResolver;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.util.LdapUtils;
import org.springframework.ldap.core.AttributesMapper;

public final class CredentialsToLDAPAttributePrincipalResolver
extends AbstractLdapPersonDirectoryCredentialsToPrincipalResolver {
    @NotNull
    private CredentialsToPrincipalResolver credentialsToPrincipalResolver;

    protected String extractPrincipalId(Credentials credentials) {
        String ldapPrincipal;
        Principal principal = this.credentialsToPrincipalResolver.resolvePrincipal(credentials);
        if (principal == null) {
            this.log.info((Object)"Initial principal could not be resolved from request, returning null");
            return null;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Resolved " + principal + ". Trying LDAP resolve now..."));
        }
        if ((ldapPrincipal = this.resolveFromLDAP(principal.getId())) == null) {
            this.log.info((Object)("Initial principal \"" + principal.getId() + "\" was not found in LDAP, returning null"));
        } else {
            this.log.debug((Object)("Resolved " + principal + " to " + ldapPrincipal));
        }
        return ldapPrincipal;
    }

    private String resolveFromLDAP(String lookupAttributeValue) {
        String searchFilter = LdapUtils.getFilterWithValues((String)this.getFilter(), (String)lookupAttributeValue);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("LDAP search with filter \"" + searchFilter + "\""));
        }
        try {
            final String idAttribute = this.getAttributeIds()[0];
            List principalList = this.getLdapTemplate().search(this.getSearchBase(), searchFilter, this.getSearchControls(), new AttributesMapper(){

                public Object mapFromAttributes(Attributes attrs) throws NamingException {
                    Attribute attribute = attrs.get(idAttribute);
                    if (attribute == null) {
                        CredentialsToLDAPAttributePrincipalResolver.this.log.debug((Object)("Principal attribute \"" + idAttribute + "\" " + "not found in LDAP search results. Returning null."));
                        return null;
                    }
                    return attribute.get();
                }
            });
            if (principalList.isEmpty()) {
                this.log.debug((Object)"LDAP search returned zero results.");
                return null;
            }
            if (principalList.size() > 1) {
                this.log.error((Object)("LDAP search returned multiple results for filter \"" + searchFilter + "\", " + "which is not allowed."));
                return null;
            }
            return (String)principalList.get(0);
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            return null;
        }
    }

    public boolean supports(Credentials credentials) {
        return this.credentialsToPrincipalResolver.supports(credentials);
    }

    public final void setCredentialsToPrincipalResolver(CredentialsToPrincipalResolver credentialsToPrincipalResolver) {
        this.credentialsToPrincipalResolver = credentialsToPrincipalResolver;
    }
}

