/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.adaptors.ldap.remote;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.inspektr.common.ioc.annotation.NotNull;
import org.jasig.cas.adaptors.ldap.remote.RemoteAddressCredentials;
import org.jasig.cas.authentication.handler.AuthenticationException;
import org.jasig.cas.authentication.handler.AuthenticationHandler;
import org.jasig.cas.authentication.principal.Credentials;

public final class RemoteAddressAuthenticationHandler
implements AuthenticationHandler {
    private final Log log = LogFactory.getLog(this.getClass());
    @NotNull
    private InetAddress inetNetmask = null;
    @NotNull
    private InetAddress inetNetwork = null;

    public boolean authenticate(Credentials credentials) throws AuthenticationException {
        RemoteAddressCredentials c = (RemoteAddressCredentials)credentials;
        try {
            InetAddress inetAddress = InetAddress.getByName(c.getRemoteAddress().trim());
            return this.containsAddress(this.inetNetwork, this.inetNetmask, inetAddress);
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    public boolean supports(Credentials credentials) {
        return credentials.getClass().equals(RemoteAddressCredentials.class);
    }

    private boolean containsAddress(InetAddress network, InetAddress netmask, InetAddress ip) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Checking IP address: " + ip + " in " + network + " / " + netmask));
        }
        byte[] networkBytes = network.getAddress();
        byte[] netmaskBytes = netmask.getAddress();
        byte[] ipBytes = ip.getAddress();
        if (networkBytes.length != netmaskBytes.length || netmaskBytes.length != ipBytes.length) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Network address " + network + ", subnet mask " + netmask + " and/or host address " + ip + " have different sizes! (return false ...)"));
            }
            return false;
        }
        for (int i = 0; i < netmaskBytes.length; ++i) {
            int mask = netmaskBytes[i] & 0xFF;
            if ((networkBytes[i] & mask) == (ipBytes[i] & mask)) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)(ip + " is not in " + network + " / " + netmask));
            }
            return false;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(ip + " is in " + network + " / " + netmask));
        }
        return true;
    }

    public void setIpNetworkRange(String ipAddressRange) {
        String[] splitAddress;
        if (ipAddressRange != null && (splitAddress = ipAddressRange.split("/")).length == 2) {
            String network = splitAddress[0].trim();
            String netmask = splitAddress[1].trim();
            try {
                this.inetNetwork = InetAddress.getByName(network);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("InetAddress network: " + this.inetNetwork.toString()));
                }
            }
            catch (UnknownHostException e) {
                this.log.error((Object)("The network address was not valid: " + e.getMessage()));
            }
            try {
                this.inetNetmask = InetAddress.getByName(netmask);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("InetAddress netmask: " + this.inetNetmask.toString()));
                }
            }
            catch (UnknownHostException e) {
                this.log.error((Object)("The network netmask was not valid: " + e.getMessage()));
            }
        }
    }
}

