/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.openid.web.flow;

import org.inspektr.common.ioc.annotation.NotNull;
import org.jasig.cas.authentication.principal.Credentials;
import org.jasig.cas.authentication.principal.WebApplicationService;
import org.jasig.cas.support.openid.authentication.principal.OpenIdCredentials;
import org.jasig.cas.support.openid.authentication.principal.OpenIdService;
import org.jasig.cas.support.openid.web.support.DefaultOpenIdUserNameExtractor;
import org.jasig.cas.support.openid.web.support.OpenIdUserNameExtractor;
import org.jasig.cas.web.flow.AbstractNonInteractiveCredentialsAction;
import org.jasig.cas.web.support.WebUtils;
import org.springframework.webflow.execution.RequestContext;

public final class OpenIdSingleSignOnAction
extends AbstractNonInteractiveCredentialsAction {
    @NotNull
    private OpenIdUserNameExtractor extractor = new DefaultOpenIdUserNameExtractor();

    public void setExtractor(OpenIdUserNameExtractor extractor) {
        this.extractor = extractor;
    }

    protected Credentials constructCredentialsFromRequest(RequestContext context) {
        String ticketGrantingTicketId = WebUtils.getTicketGrantingTicketId((RequestContext)context);
        String userName = this.extractor.extractLocalUsernameFromUri(context.getRequestParameters().get("openid.identity"));
        WebApplicationService service = WebUtils.getService((RequestContext)context);
        context.getExternalContext().getSessionMap().put("openIdLocalId", (Object)userName);
        if (service instanceof OpenIdService && userName == null) {
            context.getFlowScope().remove("service");
        }
        if (ticketGrantingTicketId == null || userName == null) {
            return null;
        }
        return new OpenIdCredentials(ticketGrantingTicketId, userName);
    }
}

