/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.intercept.web;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.springframework.context.ApplicationContext;
import org.springframework.security.ConfigAttribute;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.intercept.web.DefaultFilterInvocationDefinitionSource;
import org.springframework.security.util.UrlMatcher;
import org.springframework.util.Assert;

public class FIDSToFilterChainMapConverter {
    private LinkedHashMap filterChainMap = new LinkedHashMap();
    private UrlMatcher matcher;
    static /* synthetic */ Class class$javax$servlet$Filter;

    public FIDSToFilterChainMapConverter(DefaultFilterInvocationDefinitionSource fids, ApplicationContext appContext) {
        Assert.notNull((Object)fids.getConfigAttributeDefinitions(), (String)"FilterChainProxy requires the FilterInvocationDefinitionSource to return a non-null response to getConfigAttributeDefinitions()");
        this.matcher = fids.getUrlMatcher();
        Map requestMap = fids.getRequestMap();
        Iterator paths = requestMap.keySet().iterator();
        while (paths.hasNext()) {
            Object entry = paths.next();
            String path = entry instanceof Pattern ? ((Pattern)entry).pattern() : (String)entry;
            ConfigAttributeDefinition configAttributeDefinition = (ConfigAttributeDefinition)requestMap.get(entry);
            ArrayList<Object> filters = new ArrayList<Object>();
            Iterator attributes = configAttributeDefinition.getConfigAttributes().iterator();
            while (attributes.hasNext()) {
                ConfigAttribute attr = (ConfigAttribute)attributes.next();
                String filterName = attr.getAttribute();
                Assert.notNull((Object)filterName, (String)("Configuration attribute: '" + attr + "' returned null to the getAttribute() " + "method, which is invalid when used with FilterChainProxy"));
                if (filterName.equals("#NONE#")) continue;
                filters.add(appContext.getBean(filterName, class$javax$servlet$Filter == null ? FIDSToFilterChainMapConverter.class$("javax.servlet.Filter") : class$javax$servlet$Filter));
            }
            this.filterChainMap.put(path, filters);
        }
    }

    public Map getFilterChainMap() {
        return this.filterChainMap;
    }

    public UrlMatcher getMatcher() {
        return this.matcher;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

