/*
 * Decompiled with CFR 0.152.
 */
package org.inspektr.statistics.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Calendar;
import java.util.Date;
import org.inspektr.statistics.spi.StatisticNameResolver;
import org.inspektr.statistics.spi.support.DefaultStatisticNameResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
public @interface Statistic {
    public String applicationCode() default "";

    public Precision[] requiredPrecision() default {Precision.HOUR};

    public String name();

    public Class<? extends StatisticNameResolver> nameResolverClass() default DefaultStatisticNameResolver.class;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Precision {
        MINUTE{

            public Date normalize(Date date) {
                Calendar c1 = Calendar.getInstance();
                c1.setTime(date);
                c1.set(13, 0);
                c1.set(14, 0);
                return c1.getTime();
            }
        }
        ,
        HOUR{

            public Date normalize(Date date) {
                Calendar c1 = Calendar.getInstance();
                c1.setTime(date);
                c1.set(13, 0);
                c1.set(14, 0);
                c1.set(12, 0);
                return c1.getTime();
            }
        }
        ,
        DAY{

            public Date normalize(Date date) {
                Calendar c1 = Calendar.getInstance();
                c1.setTime(date);
                c1.set(13, 0);
                c1.set(14, 0);
                c1.set(12, 0);
                c1.set(11, 0);
                return c1.getTime();
            }
        };


        public abstract Date normalize(Date var1);

        public final boolean same(Date date1, Date date2) {
            Date normalizedDate1 = this.normalize(date1);
            Date normalizedDate2 = this.normalize(date2);
            return normalizedDate1.equals(normalizedDate2);
        }
    }
}

