/*
 * Decompiled with CFR 0.152.
 */
package org.inspektr.statistics;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.inspektr.common.ioc.annotation.NotEmpty;
import org.inspektr.common.ioc.annotation.NotNull;
import org.inspektr.common.spi.ClientInfoResolver;
import org.inspektr.common.spi.support.DefaultClientInfoResolver;
import org.inspektr.common.web.ClientInfo;
import org.inspektr.statistics.StatisticActionContext;
import org.inspektr.statistics.StatisticManager;
import org.inspektr.statistics.annotation.Statistic;
import org.inspektr.statistics.spi.StatisticNameResolver;
import org.inspektr.statistics.spi.support.DefaultStatisticNameResolver;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Aspect
public final class StatisticManagementAspect {
    @NotNull
    private final List<StatisticManager> statisticManagers;
    @NotNull
    private final String applicationCode;
    @NotNull
    private ClientInfoResolver clientInfoResolver = new DefaultClientInfoResolver();
    @NotEmpty
    private Map<Class<? extends StatisticNameResolver>, StatisticNameResolver> nameResolvers = new HashMap<Class<? extends StatisticNameResolver>, StatisticNameResolver>();

    public StatisticManagementAspect(List<StatisticManager> statisticManagers, String applicationCode) {
        this.statisticManagers = statisticManagers;
        this.applicationCode = applicationCode;
        this.nameResolvers.put(DefaultStatisticNameResolver.class, new DefaultStatisticNameResolver());
    }

    @Around(value="@annotation(statistic)", argNames="statistic")
    public Object handleStatisticGathering(ProceedingJoinPoint joinPoint, Statistic statistic) throws Throwable {
        ClientInfo clientInfo;
        Object object;
        Object retVal = null;
        String name = null;
        try {
            retVal = joinPoint.proceed();
            name = this.nameResolvers.get(statistic.nameResolverClass()).resolveFrom((JoinPoint)joinPoint, retVal, statistic);
            object = retVal;
            clientInfo = this.clientInfoResolver.resolveFrom((JoinPoint)joinPoint, retVal);
        }
        catch (Exception e) {
            try {
                name = this.nameResolvers.get(statistic.nameResolverClass()).resolveFrom((JoinPoint)joinPoint, e, statistic);
                throw e;
            }
            catch (Throwable throwable) {
                ClientInfo clientInfo2 = this.clientInfoResolver.resolveFrom((JoinPoint)joinPoint, retVal);
                String appCode = StringUtils.hasText((String)statistic.applicationCode()) ? statistic.applicationCode() : this.applicationCode;
                StatisticActionContext statisticActionContext = new StatisticActionContext(new Date(), name, statistic.requiredPrecision(), clientInfo2.getServerIpAddress(), appCode);
                for (StatisticManager manager : this.statisticManagers) {
                    manager.recalculate(statisticActionContext);
                }
                throw throwable;
            }
        }
        String appCode = StringUtils.hasText((String)statistic.applicationCode()) ? statistic.applicationCode() : this.applicationCode;
        StatisticActionContext statisticActionContext = new StatisticActionContext(new Date(), name, statistic.requiredPrecision(), clientInfo.getServerIpAddress(), appCode);
        for (StatisticManager manager : this.statisticManagers) {
            manager.recalculate(statisticActionContext);
        }
        return object;
    }

    public void setClientInfoResolver(ClientInfoResolver clientInfoResolver) {
        this.clientInfoResolver = clientInfoResolver;
    }

    public void setAdditionalStatisticNameResolvers(List<StatisticNameResolver> statisticNameResolvers) {
        for (StatisticNameResolver resolver : statisticNameResolvers) {
            this.nameResolvers.put(resolver.getClass(), resolver);
        }
    }
}

