/*
 * Decompiled with CFR 0.152.
 */
package org.inspektr.common.ioc.validation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.inspektr.common.ioc.annotation.GreaterThan;
import org.inspektr.common.ioc.annotation.IsIn;
import org.inspektr.common.ioc.annotation.NotEmpty;
import org.inspektr.common.ioc.annotation.NotNull;
import org.inspektr.common.ioc.validation.AnnotationValidator;
import org.inspektr.common.ioc.validation.GreaterThanAnnotationValidator;
import org.inspektr.common.ioc.validation.IsInAnnotationValidator;
import org.inspektr.common.ioc.validation.NotEmptyAnnotationValidator;
import org.inspektr.common.ioc.validation.NotNullAnnotationValidator;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValidationAnnotationBeanPostProcessor
extends InstantiationAwareBeanPostProcessorAdapter {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final Map<Class<? extends Annotation>, AnnotationValidator> annotationMappings = new HashMap<Class<? extends Annotation>, AnnotationValidator>();
    private final Class<? extends Annotation>[] annotations;

    public ValidationAnnotationBeanPostProcessor() {
        this.annotationMappings.put(GreaterThan.class, new GreaterThanAnnotationValidator());
        this.annotationMappings.put(IsIn.class, new IsInAnnotationValidator());
        this.annotationMappings.put(NotEmpty.class, new NotEmptyAnnotationValidator());
        this.annotationMappings.put(NotNull.class, new NotNullAnnotationValidator());
        this.annotations = this.annotationMappings.keySet().toArray(new Class[this.annotationMappings.size()]);
    }

    public final Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        ArrayList<Field> fields = new ArrayList<Field>();
        Class<?> clazz = bean.getClass();
        Class<?>[] classes = clazz.getClasses();
        this.addDeclaredFields(clazz, fields);
        for (int i = 0; i < classes.length; ++i) {
            this.addDeclaredFields(classes[i], fields);
        }
        try {
            for (Field field : fields) {
                boolean originalValue = field.isAccessible();
                field.setAccessible(true);
                for (Class<? extends Annotation> annotationClass : this.annotations) {
                    AnnotationValidator validator;
                    Annotation annotation = field.getAnnotation(annotationClass);
                    if (annotation == null || (validator = this.annotationMappings.get(annotationClass)) == null) continue;
                    validator.validate(field, annotation, bean, beanName);
                }
                field.setAccessible(originalValue);
            }
        }
        catch (IllegalAccessException e) {
            this.log.warn((Object)("Could not access field: " + e.getMessage()), (Throwable)e);
        }
        return bean;
    }

    private final void addDeclaredFields(Class<?> clazz, List<Field> fields) {
        fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
    }
}

