/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.support;

import java.math.BigInteger;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public final class ThrottledSubmissionByIpAddressHandlerInterceptorAdapter
extends HandlerInterceptorAdapter
implements InitializingBean {
    private static final int DEFAULT_FAILURE_THRESHHOLD = 100;
    private static final int DEFAULT_FAILURE_TIMEOUT = 60;
    protected static final BigInteger ONE = BigInteger.valueOf(1L);
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private ConcurrentMap<String, AtomicInteger> ipMap = new ConcurrentHashMap<String, AtomicInteger>();
    private int failureThreshhold = 100;
    int failureTimeout = 60;

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        AtomicInteger newInteger;
        if (!request.getMethod().equals("GET") || !"casLoginView".equals(modelAndView.getViewName())) {
            return;
        }
        String remoteAddr = request.getRemoteAddr();
        AtomicInteger currentInteger = this.ipMap.putIfAbsent(remoteAddr, newInteger = new AtomicInteger(0));
        AtomicInteger atomicInteger = currentInteger != null ? currentInteger : newInteger;
        atomicInteger.incrementAndGet();
        if (atomicInteger.intValue() >= this.failureThreshhold) {
            this.log.warn((Object)("Possible hacking attack from " + remoteAddr + ". More than " + this.failureThreshhold + " failed login attempts within " + this.failureTimeout + " seconds."));
            modelAndView.setViewName("casFailureAuthenticationThreshhold");
        }
    }

    public void setFailureThreshhold(int failureThreshhold) {
        this.failureThreshhold = failureThreshhold;
    }

    public void setFailureTimeout(int failureTimeout) {
        this.failureTimeout = failureTimeout;
    }

    public void afterPropertiesSet() throws Exception {
        ExpirationThread thread = new ExpirationThread(this.ipMap, this.failureTimeout);
        thread.setDaemon(true);
        thread.start();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class ExpirationThread
    extends Thread {
        private ConcurrentMap<String, AtomicInteger> ipMap;
        private int failureTimeout;

        public ExpirationThread(ConcurrentMap<String, AtomicInteger> ipMap, int failureTimeout) {
            this.ipMap = ipMap;
            this.failureTimeout = failureTimeout;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(this.failureTimeout * 1000);
                        this.cleanUpFailures();
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        private void cleanUpFailures() {
            Set keys = this.ipMap.keySet();
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                AtomicInteger integer = (AtomicInteger)this.ipMap.get(key);
                int newValue = integer.decrementAndGet();
                if (newValue != 0) continue;
                iter.remove();
            }
        }
    }
}

