/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web;

import java.net.URL;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.inspektr.common.ioc.annotation.NotNull;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.authentication.principal.Credentials;
import org.jasig.cas.authentication.principal.HttpBasedServiceCredentials;
import org.jasig.cas.authentication.principal.WebApplicationService;
import org.jasig.cas.services.UnauthorizedServiceException;
import org.jasig.cas.ticket.TicketException;
import org.jasig.cas.ticket.TicketValidationException;
import org.jasig.cas.ticket.proxy.ProxyHandler;
import org.jasig.cas.validation.Assertion;
import org.jasig.cas.validation.Cas20ProtocolValidationSpecification;
import org.jasig.cas.validation.ValidationSpecification;
import org.jasig.cas.web.support.ArgumentExtractor;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceValidateController
extends AbstractController {
    private static final String DEFAULT_SERVICE_FAILURE_VIEW_NAME = "casServiceFailureView";
    private static final String DEFAULT_SERVICE_SUCCESS_VIEW_NAME = "casServiceSuccessView";
    private static final String MODEL_PROXY_GRANTING_TICKET_IOU = "pgtIou";
    private static final String MODEL_ASSERTION = "assertion";
    @NotNull
    private CentralAuthenticationService centralAuthenticationService;
    @NotNull
    private Class<?> validationSpecificationClass = Cas20ProtocolValidationSpecification.class;
    @NotNull
    private ProxyHandler proxyHandler;
    @NotNull
    private String successView = "casServiceSuccessView";
    @NotNull
    private String failureView = "casServiceFailureView";
    @NotNull
    private ArgumentExtractor argumentExtractor;

    protected Credentials getServiceCredentialsFromRequest(HttpServletRequest request) {
        String pgtUrl = request.getParameter("pgtUrl");
        if (StringUtils.hasText((String)pgtUrl)) {
            try {
                return new HttpBasedServiceCredentials(new URL(pgtUrl));
            }
            catch (Exception e) {
                this.logger.error((Object)"Error constructing pgtUrl", (Throwable)e);
            }
        }
        return null;
    }

    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) {
        binder.setRequiredFields(new String[]{"renew"});
    }

    protected final ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String serviceTicketId;
        WebApplicationService service = this.argumentExtractor.extractService(request);
        String string = serviceTicketId = service != null ? service.getArtifactId() : null;
        if (service == null || serviceTicketId == null) {
            return this.generateErrorView("INVALID_REQUEST", "INVALID_REQUEST", null);
        }
        try {
            Credentials serviceCredentials = this.getServiceCredentialsFromRequest(request);
            String proxyGrantingTicketId = null;
            if (serviceCredentials != null) {
                try {
                    proxyGrantingTicketId = this.centralAuthenticationService.delegateTicketGrantingTicket(serviceTicketId, serviceCredentials);
                }
                catch (TicketException e) {
                    this.logger.error((Object)("TicketException generating ticket for: " + serviceCredentials), (Throwable)e);
                }
            }
            Assertion assertion = this.centralAuthenticationService.validateServiceTicket(serviceTicketId, service);
            ValidationSpecification validationSpecification = this.getCommandClass();
            ServletRequestDataBinder binder = new ServletRequestDataBinder((Object)validationSpecification, "validationSpecification");
            this.initBinder(request, binder);
            binder.bind((ServletRequest)request);
            if (!validationSpecification.isSatisfiedBy(assertion)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("ServiceTicket [" + serviceTicketId + "] does not satisfy validation specification."));
                }
                return this.generateErrorView("INVALID_TICKET", "INVALID_TICKET_SPEC", null);
            }
            ModelAndView success = new ModelAndView(this.successView);
            success.addObject(MODEL_ASSERTION, (Object)assertion);
            if (serviceCredentials != null && proxyGrantingTicketId != null) {
                String proxyIou = this.proxyHandler.handle(serviceCredentials, proxyGrantingTicketId);
                success.addObject(MODEL_PROXY_GRANTING_TICKET_IOU, (Object)proxyIou);
            }
            return success;
        }
        catch (TicketValidationException e) {
            return this.generateErrorView(e.getCode(), e.getCode(), new Object[]{serviceTicketId, e.getOriginalService().getId(), service.getId()});
        }
        catch (TicketException te) {
            return this.generateErrorView(te.getCode(), te.getCode(), new Object[]{serviceTicketId});
        }
        catch (UnauthorizedServiceException e) {
            return this.generateErrorView(e.getMessage(), e.getMessage(), null);
        }
    }

    private ModelAndView generateErrorView(String code, String description, Object[] args) {
        ModelAndView modelAndView = new ModelAndView(this.failureView);
        modelAndView.addObject("code", (Object)code);
        modelAndView.addObject("description", (Object)this.getMessageSourceAccessor().getMessage(description, args, description));
        return modelAndView;
    }

    private ValidationSpecification getCommandClass() {
        try {
            return (ValidationSpecification)this.validationSpecificationClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setCentralAuthenticationService(CentralAuthenticationService centralAuthenticationService) {
        this.centralAuthenticationService = centralAuthenticationService;
    }

    public void setArgumentExtractor(ArgumentExtractor argumentExtractor) {
        this.argumentExtractor = argumentExtractor;
    }

    public void setValidationSpecificationClass(Class<?> validationSpecificationClass) {
        this.validationSpecificationClass = validationSpecificationClass;
    }

    public void setFailureView(String failureView) {
        this.failureView = failureView;
    }

    public void setSuccessView(String successView) {
        this.successView = successView;
    }

    public void setProxyHandler(ProxyHandler proxyHandler) {
        this.proxyHandler = proxyHandler;
    }
}

