/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.util;

import org.jasig.cas.util.DefaultLongNumericGenerator;
import org.jasig.cas.util.DefaultRandomStringGenerator;
import org.jasig.cas.util.NumericGenerator;
import org.jasig.cas.util.RandomStringGenerator;
import org.jasig.cas.util.UniqueTicketIdGenerator;

public final class DefaultUniqueTicketIdGenerator
implements UniqueTicketIdGenerator {
    private final NumericGenerator numericGenerator = new DefaultLongNumericGenerator(1L);
    private final RandomStringGenerator randomStringGenerator;
    private final String suffix;

    public DefaultUniqueTicketIdGenerator() {
        this(null);
    }

    public DefaultUniqueTicketIdGenerator(int maxLength) {
        this(maxLength, null);
    }

    public DefaultUniqueTicketIdGenerator(String suffix) {
        this.randomStringGenerator = new DefaultRandomStringGenerator();
        this.suffix = suffix != null ? "-" + suffix : null;
    }

    public DefaultUniqueTicketIdGenerator(int maxLength, String suffix) {
        this.randomStringGenerator = new DefaultRandomStringGenerator(maxLength);
        this.suffix = suffix != null ? "-" + suffix : null;
    }

    public String getNewTicketId(String prefix) {
        String number = this.numericGenerator.getNextNumberAsString();
        StringBuilder buffer = new StringBuilder(prefix.length() + 2 + (this.suffix != null ? this.suffix.length() : 0) + this.randomStringGenerator.getMaxLength() + number.length());
        buffer.append(prefix);
        buffer.append("-");
        buffer.append(number);
        buffer.append("-");
        buffer.append(this.randomStringGenerator.getNewString());
        if (this.suffix != null) {
            buffer.append(this.suffix);
        }
        return buffer.toString();
    }
}

