/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.expression.support;

import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.binding.expression.EvaluationAttempt;
import org.springframework.binding.expression.EvaluationContext;
import org.springframework.binding.expression.EvaluationException;
import org.springframework.binding.expression.SetValueAttempt;
import org.springframework.binding.expression.SettableExpression;
import org.springframework.util.Assert;

class BeanWrapperExpression
implements SettableExpression {
    private String expression;

    public BeanWrapperExpression(String expression) {
        this.expression = expression;
    }

    public int hashCode() {
        return this.expression.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof BeanWrapperExpression)) {
            return false;
        }
        BeanWrapperExpression other = (BeanWrapperExpression)o;
        return this.expression.equals(other.expression);
    }

    public Object evaluate(Object target, EvaluationContext context) throws EvaluationException {
        try {
            return new BeanWrapperImpl(target).getPropertyValue(this.expression);
        }
        catch (BeansException e) {
            throw new EvaluationException(new EvaluationAttempt(this, target, context), e);
        }
    }

    public void evaluateToSet(Object target, Object value, EvaluationContext context) throws EvaluationException {
        try {
            Assert.notNull((Object)target, (String)"The target object to evaluate is required");
            new BeanWrapperImpl(target).setPropertyValue(this.expression, value);
        }
        catch (BeansException e) {
            throw new EvaluationException(new SetValueAttempt(this, target, value, context), e);
        }
    }

    public String toString() {
        return this.expression;
    }
}

