/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;

public class RandomGuid {
    private static Random random;
    private static SecureRandom secureRandom;
    private static String id;
    private String guid;

    public RandomGuid() {
        this.getRandomGuid(false);
    }

    public RandomGuid(boolean secure) {
        this.getRandomGuid(secure);
    }

    private void getRandomGuid(boolean secure) {
        MessageDigest md5 = null;
        StringBuffer sbValueBeforeMD5 = new StringBuffer();
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        long time = System.currentTimeMillis();
        long rand = 0L;
        rand = secure ? secureRandom.nextLong() : random.nextLong();
        sbValueBeforeMD5.append(id);
        sbValueBeforeMD5.append(":");
        sbValueBeforeMD5.append(Long.toString(time));
        sbValueBeforeMD5.append(":");
        sbValueBeforeMD5.append(Long.toString(rand));
        String valueBeforeMD5 = sbValueBeforeMD5.toString();
        md5.update(valueBeforeMD5.getBytes());
        byte[] array = md5.digest();
        StringBuffer sb = new StringBuffer();
        for (int j = 0; j < array.length; ++j) {
            int b = array[j] & 0xFF;
            if (b < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(b));
        }
        this.guid = sb.toString();
    }

    public String toString() {
        String raw = this.guid.toUpperCase();
        StringBuffer sb = new StringBuffer();
        sb.append(raw.substring(0, 8));
        sb.append("-");
        sb.append(raw.substring(8, 12));
        sb.append("-");
        sb.append(raw.substring(12, 16));
        sb.append("-");
        sb.append(raw.substring(16, 20));
        sb.append("-");
        sb.append(raw.substring(20));
        return sb.toString();
    }

    static {
        secureRandom = new SecureRandom();
        long secureInitializer = secureRandom.nextLong();
        random = new Random(secureInitializer);
        try {
            id = InetAddress.getLocalHost().toString();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }
}

