/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.executor.support;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import org.springframework.core.JdkVersion;
import org.springframework.util.StringUtils;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.execution.FlowExecutionContext;
import org.springframework.webflow.execution.support.ExternalRedirect;
import org.springframework.webflow.execution.support.FlowDefinitionRedirect;
import org.springframework.webflow.executor.support.FlowExecutorArgumentExposer;
import org.springframework.webflow.executor.support.FlowExecutorArgumentExtractionException;
import org.springframework.webflow.executor.support.FlowExecutorArgumentExtractor;

public abstract class FlowExecutorArgumentHandler
implements FlowExecutorArgumentExtractor,
FlowExecutorArgumentExposer {
    private static final String FLOW_ID_ARGUMENT_NAME = "_flowId";
    private static final String FLOW_EXECUTION_KEY_ARGUMENT_NAME = "_flowExecutionKey";
    private static final String EVENT_ID_ARGUMENT_NAME = "_eventId";
    private String flowIdArgumentName = "_flowId";
    private String flowExecutionKeyArgumentName = "_flowExecutionKey";
    private String eventIdArgumentName = "_eventId";
    private String defaultFlowId;
    private static final String FLOW_EXECUTION_KEY_ATTRIBUTE = "flowExecutionKey";
    private static final String FLOW_EXECUTION_CONTEXT_ATTRIBUTE = "flowExecutionContext";
    private static final String DEFAULT_URL_ENCODING_SCHEME = "UTF-8";
    private String flowExecutionKeyAttributeName = "flowExecutionKey";
    private String flowExecutionContextAttributeName = "flowExecutionContext";
    private String urlEncodingScheme = "UTF-8";
    private boolean redirectContextRelative = true;

    public String getFlowIdArgumentName() {
        return this.flowIdArgumentName;
    }

    public void setFlowIdArgumentName(String flowIdArgumentName) {
        this.flowIdArgumentName = flowIdArgumentName;
    }

    public String getFlowExecutionKeyArgumentName() {
        return this.flowExecutionKeyArgumentName;
    }

    public void setFlowExecutionKeyArgumentName(String flowExecutionKeyArgumentName) {
        this.flowExecutionKeyArgumentName = flowExecutionKeyArgumentName;
    }

    public String getEventIdArgumentName() {
        return this.eventIdArgumentName;
    }

    public void setEventIdArgumentName(String eventIdArgumentName) {
        this.eventIdArgumentName = eventIdArgumentName;
    }

    public String getDefaultFlowId() {
        return this.defaultFlowId;
    }

    public void setDefaultFlowId(String defaultFlowId) {
        this.defaultFlowId = defaultFlowId;
    }

    public String getFlowExecutionKeyAttributeName() {
        return this.flowExecutionKeyAttributeName;
    }

    public void setFlowExecutionKeyAttributeName(String flowExecutionKeyAttributeName) {
        this.flowExecutionKeyAttributeName = flowExecutionKeyAttributeName;
    }

    public String getFlowExecutionContextAttributeName() {
        return this.flowExecutionContextAttributeName;
    }

    public void setFlowExecutionContextAttributeName(String flowExecutionContextAttributeName) {
        this.flowExecutionContextAttributeName = flowExecutionContextAttributeName;
    }

    public String getUrlEncodingScheme() {
        return this.urlEncodingScheme;
    }

    public void setUrlEncodingScheme(String urlEncodingScheme) {
        this.urlEncodingScheme = urlEncodingScheme;
    }

    public void setRedirectContextRelative(boolean redirectContextRelative) {
        this.redirectContextRelative = redirectContextRelative;
    }

    public boolean isRedirectContextRelative() {
        return this.redirectContextRelative;
    }

    public abstract boolean isFlowIdPresent(ExternalContext var1);

    public abstract String extractFlowId(ExternalContext var1) throws FlowExecutorArgumentExtractionException;

    public abstract boolean isFlowExecutionKeyPresent(ExternalContext var1);

    public abstract String extractFlowExecutionKey(ExternalContext var1) throws FlowExecutorArgumentExtractionException;

    public abstract boolean isEventIdPresent(ExternalContext var1);

    public abstract String extractEventId(ExternalContext var1) throws FlowExecutorArgumentExtractionException;

    public void exposeFlowExecutionContext(String flowExecutionKey, FlowExecutionContext context, Map model) {
        if (flowExecutionKey != null) {
            model.put(this.getFlowExecutionKeyAttributeName(), flowExecutionKey);
        }
        model.put(this.getFlowExecutionContextAttributeName(), context);
    }

    public abstract String createFlowDefinitionUrl(FlowDefinitionRedirect var1, ExternalContext var2);

    public abstract String createFlowExecutionUrl(String var1, FlowExecutionContext var2, ExternalContext var3);

    public abstract String createExternalUrl(ExternalRedirect var1, String var2, ExternalContext var3);

    protected String applyDefaultFlowId(String extractedFlowId) {
        return StringUtils.hasText((String)extractedFlowId) ? extractedFlowId : this.getDefaultFlowId();
    }

    protected String encodeValue(Object value) {
        return value != null ? this.urlEncode(value.toString()) : "";
    }

    protected String makeRedirectUrlContextRelativeIfNecessary(String url, ExternalContext context) {
        StringBuffer res = new StringBuffer();
        if (url.startsWith("/") && this.isRedirectContextRelative()) {
            res.append(context.getContextPath());
        }
        res.append(url);
        return res.toString();
    }

    private String urlEncode(String input) {
        if (JdkVersion.getMajorJavaVersion() < 1) {
            return URLEncoder.encode(input);
        }
        try {
            return URLEncoder.encode(input, this.getUrlEncodingScheme());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Cannot encode URL " + input);
        }
    }
}

