/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution.support;

import java.util.Collections;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.webflow.execution.ViewSelection;

public final class FlowDefinitionRedirect
extends ViewSelection {
    private final String flowDefinitionId;
    private final Map executionInput;

    public FlowDefinitionRedirect(String flowDefinitionId, Map executionInput) {
        Assert.hasText((String)flowDefinitionId, (String)"The flow definition id is required");
        this.flowDefinitionId = flowDefinitionId;
        if (executionInput == null) {
            executionInput = Collections.EMPTY_MAP;
        }
        this.executionInput = executionInput;
    }

    public String getFlowDefinitionId() {
        return this.flowDefinitionId;
    }

    public Map getExecutionInput() {
        return Collections.unmodifiableMap(this.executionInput);
    }

    public boolean equals(Object o) {
        if (!(o instanceof FlowDefinitionRedirect)) {
            return false;
        }
        FlowDefinitionRedirect other = (FlowDefinitionRedirect)o;
        return this.flowDefinitionId.equals(other.flowDefinitionId) && ((Object)this.executionInput).equals(other.executionInput);
    }

    public int hashCode() {
        return this.flowDefinitionId.hashCode() + ((Object)this.executionInput).hashCode();
    }

    public String toString() {
        return "flowRedirect:'" + this.flowDefinitionId + "'";
    }
}

