/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.support;

import org.springframework.binding.expression.EvaluationContext;
import org.springframework.binding.expression.EvaluationException;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.SettableExpression;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.ScopeType;

public class AttributeExpression
implements SettableExpression {
    private Expression expression;
    private ScopeType scopeType;
    static /* synthetic */ Class class$org$springframework$binding$expression$SettableExpression;

    public AttributeExpression(Expression expression) {
        this(expression, null);
    }

    public AttributeExpression(Expression expression, ScopeType scopeType) {
        this.expression = expression;
        this.scopeType = scopeType;
    }

    protected Expression getExpression() {
        return this.expression;
    }

    public Object evaluate(Object target, EvaluationContext context) throws EvaluationException {
        if (target instanceof RequestContext) {
            RequestContext requestContext = (RequestContext)target;
            MutableAttributeMap scope = this.scopeType.getScope(requestContext);
            return this.expression.evaluate((Object)scope, context);
        }
        if (target instanceof AttributeMap) {
            return this.expression.evaluate(target, context);
        }
        throw new IllegalArgumentException("Only supports evaluation against a [RequestContext] or [AttributeMap] instance, but was a [" + target.getClass() + "]");
    }

    public void evaluateToSet(Object target, Object value, EvaluationContext context) throws EvaluationException {
        Assert.isInstanceOf((Class)(class$org$springframework$binding$expression$SettableExpression == null ? (class$org$springframework$binding$expression$SettableExpression = AttributeExpression.class$("org.springframework.binding.expression.SettableExpression")) : class$org$springframework$binding$expression$SettableExpression), (Object)this.expression, (String)"When an AttributeExpression is used to set a property value, the nested expression needs to be a SettableExpression");
        if (target instanceof RequestContext) {
            RequestContext requestContext = (RequestContext)target;
            MutableAttributeMap scope = this.scopeType.getScope(requestContext);
            ((SettableExpression)this.expression).evaluateToSet((Object)scope, value, context);
        } else if (target instanceof AttributeMap) {
            ((SettableExpression)this.expression).evaluateToSet(target, value, context);
        } else {
            throw new IllegalArgumentException("Only supports evaluation against a [RequestContext] or [AttributeMap] instance, but was a [" + target.getClass() + "]");
        }
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("expression", (Object)this.expression).toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

