/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.impl;

import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.definition.StateDefinition;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.FlowExecutionException;
import org.springframework.webflow.execution.FlowExecutionListener;
import org.springframework.webflow.execution.FlowSession;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.ViewSelection;

class FlowExecutionListeners {
    private FlowExecutionListener[] listeners;

    public FlowExecutionListeners() {
        this(null);
    }

    public FlowExecutionListeners(FlowExecutionListener[] listeners) {
        this.listeners = listeners != null ? listeners : new FlowExecutionListener[0];
    }

    public FlowExecutionListener[] getArray() {
        return this.listeners;
    }

    public int size() {
        return this.listeners.length;
    }

    public void fireRequestSubmitted(RequestContext context) {
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].requestSubmitted(context);
        }
    }

    public void fireRequestProcessed(RequestContext context) {
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].requestProcessed(context);
        }
    }

    public void fireSessionStarting(RequestContext context, FlowDefinition flow, MutableAttributeMap input) {
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].sessionStarting(context, flow, input);
        }
    }

    public void fireSessionCreated(RequestContext context, FlowSession session) {
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].sessionCreated(context, session);
        }
    }

    public void fireSessionStarted(RequestContext context, FlowSession session) {
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].sessionStarted(context, session);
        }
    }

    public void fireEventSignaled(RequestContext context, Event event) {
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].eventSignaled(context, event);
        }
    }

    public void fireStateEntering(RequestContext context, StateDefinition nextState) {
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].stateEntering(context, nextState);
        }
    }

    public void fireStateEntered(RequestContext context, StateDefinition previousState) {
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].stateEntered(context, previousState, context.getCurrentState());
        }
    }

    public void firePaused(RequestContext context, ViewSelection selectedView) {
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].paused(context, selectedView);
        }
    }

    public void fireResumed(RequestContext context) {
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].resumed(context);
        }
    }

    public void fireSessionEnding(RequestContext context, FlowSession session, MutableAttributeMap output) {
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].sessionEnding(context, session, output);
        }
    }

    public void fireSessionEnded(RequestContext context, FlowSession session, AttributeMap output) {
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].sessionEnded(context, session, output);
        }
    }

    public void fireExceptionThrown(RequestContext context, FlowExecutionException exception) {
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].exceptionThrown(context, exception);
        }
    }
}

