/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.builder;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.definition.registry.FlowDefinitionConstructionException;
import org.springframework.webflow.definition.registry.FlowDefinitionHolder;
import org.springframework.webflow.engine.builder.FlowAssembler;
import org.springframework.webflow.engine.builder.FlowBuilder;
import org.springframework.webflow.engine.builder.FlowBuilderException;
import org.springframework.webflow.util.ResourceHolder;

public class RefreshableFlowDefinitionHolder
implements FlowDefinitionHolder {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$webflow$engine$builder$RefreshableFlowDefinitionHolder == null ? (class$org$springframework$webflow$engine$builder$RefreshableFlowDefinitionHolder = RefreshableFlowDefinitionHolder.class$("org.springframework.webflow.engine.builder.RefreshableFlowDefinitionHolder")) : class$org$springframework$webflow$engine$builder$RefreshableFlowDefinitionHolder));
    private FlowDefinition flowDefinition;
    private FlowAssembler assembler;
    private long lastModified;
    private boolean assembling;
    static /* synthetic */ Class class$org$springframework$webflow$engine$builder$RefreshableFlowDefinitionHolder;

    public RefreshableFlowDefinitionHolder(FlowAssembler assembler) {
        this.assembler = assembler;
    }

    public String getFlowDefinitionId() {
        return this.assembler.getFlowId();
    }

    public synchronized FlowDefinition getFlowDefinition() throws FlowDefinitionConstructionException {
        if (this.assembling) {
            return this.getFlowBuilder().getFlow();
        }
        if (!this.isAssembled()) {
            this.lastModified = this.calculateLastModified();
            this.assembleFlow();
        } else {
            this.refreshIfChanged();
        }
        return this.flowDefinition;
    }

    public synchronized void refresh() throws FlowBuilderException {
        this.assembleFlow();
    }

    protected FlowBuilder getFlowBuilder() {
        return this.assembler.getFlowBuilder();
    }

    protected void refreshIfChanged() {
        if (this.lastModified == -1L) {
            return;
        }
        long calculatedLastModified = this.calculateLastModified();
        if (this.lastModified < calculatedLastModified) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Resource modification detected, reloading flow definition with id '" + this.assembler.getFlowId() + "'"));
            }
            this.assembleFlow();
            this.lastModified = calculatedLastModified;
        }
    }

    protected long calculateLastModified() {
        if (this.getFlowBuilder() instanceof ResourceHolder) {
            Resource resource = ((ResourceHolder)((Object)this.getFlowBuilder())).getResource();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Calculating last modified timestamp for flow definition resource '" + resource + "'"));
            }
            try {
                return resource.getFile().lastModified();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return -1L;
    }

    protected long getLastModified() {
        return this.lastModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assembleFlow() throws FlowBuilderException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Assembling flow definition with id '" + this.assembler.getFlowId() + "'"));
        }
        try {
            this.assembling = true;
            this.flowDefinition = this.assembler.assembleFlow();
        }
        finally {
            this.assembling = false;
        }
    }

    protected boolean isAssembled() {
        return this.flowDefinition != null;
    }

    protected boolean isAssembling() {
        return this.assembling;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

