/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.builder;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.CollectionUtils;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.builder.FlowBuilder;
import org.springframework.webflow.engine.builder.FlowBuilderException;

public class FlowAssembler {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$webflow$engine$builder$FlowAssembler == null ? (class$org$springframework$webflow$engine$builder$FlowAssembler = FlowAssembler.class$("org.springframework.webflow.engine.builder.FlowAssembler")) : class$org$springframework$webflow$engine$builder$FlowAssembler));
    private String flowId;
    private AttributeMap flowAttributes;
    private FlowBuilder flowBuilder;
    static /* synthetic */ Class class$org$springframework$webflow$engine$builder$FlowAssembler;

    public FlowAssembler(String flowId, FlowBuilder flowBuilder) {
        this(flowId, null, flowBuilder);
    }

    public FlowAssembler(String flowId, AttributeMap flowAttributes, FlowBuilder flowBuilder) {
        Assert.hasText((String)flowId, (String)"The flow id is required");
        Assert.notNull((Object)flowBuilder, (String)"The flow builder is required");
        this.flowId = flowId;
        this.flowAttributes = flowAttributes != null ? flowAttributes : CollectionUtils.EMPTY_ATTRIBUTE_MAP;
        this.flowBuilder = flowBuilder;
    }

    public String getFlowId() {
        return this.flowId;
    }

    public AttributeMap getFlowAttributes() {
        return this.flowAttributes;
    }

    public FlowBuilder getFlowBuilder() {
        return this.flowBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Flow assembleFlow() throws FlowBuilderException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Assembling flow definition with id '" + this.flowId + "' using flow builder '" + this.flowBuilder + "'; externally assigned flow attributes are '" + this.flowAttributes + "'"));
        }
        try {
            this.flowBuilder.init(this.flowId, this.flowAttributes);
            this.directAssembly();
            Flow flow = this.flowBuilder.getFlow();
            return flow;
        }
        finally {
            this.flowBuilder.dispose();
        }
    }

    protected void directAssembly() throws FlowBuilderException {
        this.flowBuilder.buildVariables();
        this.flowBuilder.buildInputMapper();
        this.flowBuilder.buildStartActions();
        this.flowBuilder.buildInlineFlows();
        this.flowBuilder.buildStates();
        this.flowBuilder.buildGlobalTransitions();
        this.flowBuilder.buildEndActions();
        this.flowBuilder.buildOutputMapper();
        this.flowBuilder.buildExceptionHandlers();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

