/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.builder;

import org.springframework.binding.mapping.AttributeMapper;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.engine.ActionState;
import org.springframework.webflow.engine.DecisionState;
import org.springframework.webflow.engine.EndState;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.FlowAttributeMapper;
import org.springframework.webflow.engine.FlowExecutionExceptionHandler;
import org.springframework.webflow.engine.State;
import org.springframework.webflow.engine.SubflowState;
import org.springframework.webflow.engine.TargetStateResolver;
import org.springframework.webflow.engine.Transition;
import org.springframework.webflow.engine.TransitionCriteria;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.ViewSelector;
import org.springframework.webflow.engine.ViewState;
import org.springframework.webflow.engine.builder.FlowArtifactLookupException;
import org.springframework.webflow.execution.Action;

public class FlowArtifactFactory {
    public Flow createFlow(String id, AttributeMap attributes) throws FlowArtifactLookupException {
        Flow flow = new Flow(id);
        flow.getAttributeMap().putAll(attributes);
        return flow;
    }

    public State createViewState(String id, Flow flow, Action[] entryActions, ViewSelector viewSelector, Action[] renderActions, Transition[] transitions, FlowExecutionExceptionHandler[] exceptionHandlers, Action[] exitActions, AttributeMap attributes) throws FlowArtifactLookupException {
        ViewState viewState = new ViewState(flow, id);
        if (viewSelector != null) {
            viewState.setViewSelector(viewSelector);
        }
        viewState.getRenderActionList().addAll(renderActions);
        this.configureCommonProperties(viewState, entryActions, transitions, exceptionHandlers, exitActions, attributes);
        return viewState;
    }

    public State createActionState(String id, Flow flow, Action[] entryActions, Action[] actions, Transition[] transitions, FlowExecutionExceptionHandler[] exceptionHandlers, Action[] exitActions, AttributeMap attributes) throws FlowArtifactLookupException {
        ActionState actionState = new ActionState(flow, id);
        actionState.getActionList().addAll(actions);
        this.configureCommonProperties(actionState, entryActions, transitions, exceptionHandlers, exitActions, attributes);
        return actionState;
    }

    public State createDecisionState(String id, Flow flow, Action[] entryActions, Transition[] transitions, FlowExecutionExceptionHandler[] exceptionHandlers, Action[] exitActions, AttributeMap attributes) throws FlowArtifactLookupException {
        DecisionState decisionState = new DecisionState(flow, id);
        this.configureCommonProperties(decisionState, entryActions, transitions, exceptionHandlers, exitActions, attributes);
        return decisionState;
    }

    public State createSubflowState(String id, Flow flow, Action[] entryActions, Flow subflow, FlowAttributeMapper attributeMapper, Transition[] transitions, FlowExecutionExceptionHandler[] exceptionHandlers, Action[] exitActions, AttributeMap attributes) throws FlowArtifactLookupException {
        SubflowState subflowState = new SubflowState(flow, id, subflow);
        if (attributeMapper != null) {
            subflowState.setAttributeMapper(attributeMapper);
        }
        this.configureCommonProperties(subflowState, entryActions, transitions, exceptionHandlers, exitActions, attributes);
        return subflowState;
    }

    public State createEndState(String id, Flow flow, Action[] entryActions, ViewSelector viewSelector, AttributeMapper outputMapper, FlowExecutionExceptionHandler[] exceptionHandlers, AttributeMap attributes) throws FlowArtifactLookupException {
        EndState endState = new EndState(flow, id);
        if (viewSelector != null) {
            endState.setViewSelector(viewSelector);
        }
        if (outputMapper != null) {
            endState.setOutputMapper(outputMapper);
        }
        this.configureCommonProperties(endState, entryActions, exceptionHandlers, attributes);
        return endState;
    }

    public Transition createTransition(TargetStateResolver targetStateResolver, TransitionCriteria matchingCriteria, TransitionCriteria executionCriteria, AttributeMap attributes) throws FlowArtifactLookupException {
        Transition transition = new Transition(targetStateResolver);
        if (matchingCriteria != null) {
            transition.setMatchingCriteria(matchingCriteria);
        }
        if (executionCriteria != null) {
            transition.setExecutionCriteria(executionCriteria);
        }
        transition.getAttributeMap().putAll(attributes);
        return transition;
    }

    private void configureCommonProperties(TransitionableState state, Action[] entryActions, Transition[] transitions, FlowExecutionExceptionHandler[] exceptionHandlers, Action[] exitActions, AttributeMap attributes) {
        this.configureCommonProperties(state, entryActions, exceptionHandlers, attributes);
        state.getTransitionSet().addAll(transitions);
        state.getExitActionList().addAll(exitActions);
    }

    private void configureCommonProperties(State state, Action[] entryActions, FlowExecutionExceptionHandler[] exceptionHandlers, AttributeMap attributes) {
        state.getEntryActionList().addAll(entryActions);
        state.getExceptionHandlerSet().addAll(exceptionHandlers);
        state.getAttributeMap().putAll(attributes);
    }
}

