/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.action;

import java.io.Serializable;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.ScopeType;

public class ActionResultExposer
implements Serializable {
    private String resultName;
    private ScopeType resultScope;

    public ActionResultExposer(String resultName, ScopeType resultScope) {
        Assert.notNull((Object)resultName, (String)"The result name is required");
        Assert.notNull((Object)((Object)resultScope), (String)"The result scope is required");
        this.resultName = resultName;
        this.resultScope = resultScope;
    }

    public String getResultName() {
        return this.resultName;
    }

    public ScopeType getResultScope() {
        return this.resultScope;
    }

    public void exposeResult(Object result, RequestContext context) {
        this.resultScope.getScope(context).put(this.resultName, result);
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("resultName", (Object)this.resultName).append("resultScope", (Object)this.resultScope).toString();
    }
}

