/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.executor.jsf;

import javax.faces.context.FacesContext;
import javax.faces.el.PropertyResolver;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.jsf.FacesContextUtils;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.executor.jsf.AbstractFlowExecutionPropertyResolver;

public class FlowPropertyResolver
extends AbstractFlowExecutionPropertyResolver {
    public FlowPropertyResolver(PropertyResolver resolverDelegate) {
        super(resolverDelegate);
    }

    protected Class doGetAttributeType(FlowExecution execution, String attributeName) {
        Object value = execution.getActiveSession().getScope().get(attributeName);
        return value == null ? null : value.getClass();
    }

    protected Object doGetAttribute(FlowExecution execution, String attributeName) {
        Object value = execution.getActiveSession().getScope().get(attributeName);
        if (value == null) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            Assert.notNull((Object)facesContext, (String)"The current FacesContext must be present during property resolution stage");
            WebApplicationContext beanFactory = this.getWebApplicationContext(facesContext);
            if (beanFactory.containsBean(attributeName)) {
                value = beanFactory.getBean(attributeName);
                execution.getActiveSession().getScope().put(attributeName, value);
            }
        }
        return value;
    }

    protected void doSetAttribute(FlowExecution execution, String attributeName, Object attributeValue) {
        execution.getActiveSession().getScope().put(attributeName, attributeValue);
    }

    protected WebApplicationContext getWebApplicationContext(FacesContext facesContext) {
        return FacesContextUtils.getRequiredWebApplicationContext((FacesContext)facesContext);
    }
}

