/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.executor.jsf;

import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.VariableResolver;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.executor.jsf.FlowExecutionHolderUtils;

public class DelegatingFlowVariableResolver
extends VariableResolver {
    private VariableResolver resolverDelegate;

    public DelegatingFlowVariableResolver(VariableResolver resolverDelegate) {
        this.resolverDelegate = resolverDelegate;
    }

    protected final VariableResolver getResolverDelegate() {
        return this.resolverDelegate;
    }

    public Object resolveVariable(FacesContext context, String name) throws EvaluationException {
        FlowExecution execution = FlowExecutionHolderUtils.getCurrentFlowExecution(context);
        if (execution != null) {
            if (execution.isActive()) {
                if (execution.getActiveSession().getFlashMap().contains(name)) {
                    return execution.getActiveSession().getFlashMap().get(name);
                }
                if (execution.getActiveSession().getScope().contains(name)) {
                    return execution.getActiveSession().getScope().get(name);
                }
                if (execution.getConversationScope().contains(name)) {
                    return execution.getConversationScope().get(name);
                }
            } else if (context.getExternalContext().getRequestMap().containsKey(name)) {
                return context.getExternalContext().getRequestMap().get(name);
            }
        }
        return this.resolverDelegate.resolveVariable(context, name);
    }
}

