/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution.repository.continuation;

import java.io.Serializable;
import org.springframework.util.Assert;
import org.springframework.webflow.conversation.Conversation;
import org.springframework.webflow.conversation.ConversationManager;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.repository.FlowExecutionKey;
import org.springframework.webflow.execution.repository.FlowExecutionRestorationFailureException;
import org.springframework.webflow.execution.repository.continuation.ContinuationNotFoundException;
import org.springframework.webflow.execution.repository.continuation.ContinuationUnmarshalException;
import org.springframework.webflow.execution.repository.continuation.FlowExecutionContinuation;
import org.springframework.webflow.execution.repository.continuation.FlowExecutionContinuationFactory;
import org.springframework.webflow.execution.repository.continuation.FlowExecutionContinuationGroup;
import org.springframework.webflow.execution.repository.continuation.SerializedFlowExecutionContinuationFactory;
import org.springframework.webflow.execution.repository.support.AbstractConversationFlowExecutionRepository;
import org.springframework.webflow.execution.repository.support.FlowExecutionStateRestorer;
import org.springframework.webflow.util.RandomGuidUidGenerator;
import org.springframework.webflow.util.UidGenerator;

public class ContinuationFlowExecutionRepository
extends AbstractConversationFlowExecutionRepository {
    private static final String CONTINUATION_GROUP_ATTRIBUTE = "continuationGroup";
    private FlowExecutionContinuationFactory continuationFactory = new SerializedFlowExecutionContinuationFactory();
    private UidGenerator continuationIdGenerator = new RandomGuidUidGenerator();
    private int maxContinuations = 30;

    public ContinuationFlowExecutionRepository(FlowExecutionStateRestorer executionStateRestorer, ConversationManager conversationManager) {
        super(executionStateRestorer, conversationManager);
    }

    public FlowExecutionContinuationFactory getContinuationFactory() {
        return this.continuationFactory;
    }

    public void setContinuationFactory(FlowExecutionContinuationFactory continuationFactory) {
        Assert.notNull((Object)continuationFactory, (String)"The continuation factory is required");
        this.continuationFactory = continuationFactory;
    }

    public UidGenerator getContinuationIdGenerator() {
        return this.continuationIdGenerator;
    }

    public void setContinuationIdGenerator(UidGenerator continuationIdGenerator) {
        Assert.notNull((Object)continuationIdGenerator, (String)"The continuation id generator is required");
        this.continuationIdGenerator = continuationIdGenerator;
    }

    public int getMaxContinuations() {
        return this.maxContinuations;
    }

    public void setMaxContinuations(int maxContinuations) {
        this.maxContinuations = maxContinuations;
    }

    public FlowExecution getFlowExecution(FlowExecutionKey key) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Getting flow execution with key '" + key + "'"));
        }
        FlowExecutionContinuation continuation = this.getContinuation(key);
        try {
            FlowExecution execution = continuation.unmarshal();
            return this.getExecutionStateRestorer().restoreState(execution, this.getConversationScope(key));
        }
        catch (ContinuationUnmarshalException e) {
            throw new FlowExecutionRestorationFailureException(key, (Exception)((Object)e));
        }
    }

    public void putFlowExecution(FlowExecutionKey key, FlowExecution flowExecution) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Putting flow execution '" + flowExecution + "' into repository with key '" + key + "'"));
        }
        FlowExecutionContinuationGroup continuationGroup = this.getContinuationGroup(key);
        FlowExecutionContinuation continuation = this.continuationFactory.createContinuation(flowExecution);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Adding new continuation to group with id " + this.getContinuationId(key)));
        }
        continuationGroup.add(this.getContinuationId(key), continuation);
        this.putConversationScope(key, flowExecution.getConversationScope());
    }

    protected Serializable generateContinuationId(FlowExecution flowExecution) {
        return this.continuationIdGenerator.generateUid();
    }

    protected Serializable parseContinuationId(String encodedId) {
        return this.continuationIdGenerator.parseUid(encodedId);
    }

    FlowExecutionContinuationGroup getContinuationGroup(FlowExecutionKey key) {
        Conversation conversation = this.getConversation(key);
        FlowExecutionContinuationGroup group = (FlowExecutionContinuationGroup)conversation.getAttribute(CONTINUATION_GROUP_ATTRIBUTE);
        if (group == null) {
            group = new FlowExecutionContinuationGroup(this.maxContinuations);
            conversation.putAttribute(CONTINUATION_GROUP_ATTRIBUTE, group);
        }
        return group;
    }

    protected FlowExecutionContinuation getContinuation(FlowExecutionKey key) throws FlowExecutionRestorationFailureException {
        try {
            return this.getContinuationGroup(key).get(this.getContinuationId(key));
        }
        catch (ContinuationNotFoundException e) {
            throw new FlowExecutionRestorationFailureException(key, (Exception)((Object)e));
        }
    }
}

