/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.builder.xml;

import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.webflow.definition.registry.ExternalizedFlowDefinitionRegistrar;
import org.springframework.webflow.definition.registry.FlowDefinitionHolder;
import org.springframework.webflow.definition.registry.FlowDefinitionResource;
import org.springframework.webflow.engine.builder.FlowAssembler;
import org.springframework.webflow.engine.builder.FlowBuilder;
import org.springframework.webflow.engine.builder.FlowServiceLocator;
import org.springframework.webflow.engine.builder.RefreshableFlowDefinitionHolder;
import org.springframework.webflow.engine.builder.xml.DocumentLoader;
import org.springframework.webflow.engine.builder.xml.XmlFlowBuilder;

public class XmlFlowRegistrar
extends ExternalizedFlowDefinitionRegistrar {
    private static final String XML_SUFFIX = ".xml";
    private FlowServiceLocator flowServiceLocator;
    private DocumentLoader documentLoader;

    protected XmlFlowRegistrar() {
    }

    public XmlFlowRegistrar(FlowServiceLocator flowServiceLocator) {
        this.setFlowServiceLocator(flowServiceLocator);
    }

    protected void setFlowServiceLocator(FlowServiceLocator flowServiceLocator) {
        Assert.notNull((Object)flowServiceLocator, (String)"The flow service locator is required");
        this.flowServiceLocator = flowServiceLocator;
    }

    protected FlowServiceLocator getFlowServiceLocator() {
        return this.flowServiceLocator;
    }

    public void setDocumentLoader(DocumentLoader documentLoader) {
        this.documentLoader = documentLoader;
    }

    public DocumentLoader getDocumentLoader() {
        return this.documentLoader;
    }

    protected boolean isFlowDefinitionResource(Resource resource) {
        return resource.getFilename().endsWith(XML_SUFFIX);
    }

    protected FlowDefinitionHolder createFlowDefinitionHolder(FlowDefinitionResource resource) {
        FlowBuilder builder = this.createFlowBuilder(resource.getLocation());
        FlowAssembler assembler = new FlowAssembler(resource.getId(), resource.getAttributes(), builder);
        return new RefreshableFlowDefinitionHolder(assembler);
    }

    protected FlowBuilder createFlowBuilder(Resource location) {
        XmlFlowBuilder builder = new XmlFlowBuilder(location, this.getFlowServiceLocator());
        if (this.documentLoader != null) {
            builder.setDocumentLoader(this.documentLoader);
        }
        return builder;
    }
}

