/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.builder;

import org.springframework.binding.convert.ConversionContext;
import org.springframework.binding.convert.ConversionException;
import org.springframework.binding.convert.support.AbstractConverter;
import org.springframework.binding.expression.Expression;
import org.springframework.util.StringUtils;
import org.springframework.webflow.engine.TransitionCriteria;
import org.springframework.webflow.engine.WildcardTransitionCriteria;
import org.springframework.webflow.engine.builder.FlowServiceLocator;
import org.springframework.webflow.engine.support.BooleanExpressionTransitionCriteria;
import org.springframework.webflow.engine.support.EventIdTransitionCriteria;

public class TextToTransitionCriteria
extends AbstractConverter {
    private static final String BEAN_PREFIX = "bean:";
    private FlowServiceLocator flowServiceLocator;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$springframework$webflow$engine$TransitionCriteria;

    public TextToTransitionCriteria(FlowServiceLocator flowServiceLocator) {
        this.flowServiceLocator = flowServiceLocator;
    }

    public Class[] getSourceClasses() {
        return new Class[]{class$java$lang$String == null ? (class$java$lang$String = TextToTransitionCriteria.class$("java.lang.String")) : class$java$lang$String};
    }

    public Class[] getTargetClasses() {
        return new Class[]{class$org$springframework$webflow$engine$TransitionCriteria == null ? (class$org$springframework$webflow$engine$TransitionCriteria = TextToTransitionCriteria.class$("org.springframework.webflow.engine.TransitionCriteria")) : class$org$springframework$webflow$engine$TransitionCriteria};
    }

    protected Object doConvert(Object source, Class targetClass, ConversionContext context) throws Exception {
        String encodedCriteria = (String)source;
        if (!StringUtils.hasText((String)encodedCriteria) || "*".equals(encodedCriteria)) {
            return WildcardTransitionCriteria.INSTANCE;
        }
        if (this.flowServiceLocator.getExpressionParser().isDelimitedExpression(encodedCriteria)) {
            Expression expression = this.flowServiceLocator.getExpressionParser().parseExpression(encodedCriteria);
            return this.createBooleanExpressionTransitionCriteria(expression);
        }
        if (encodedCriteria.startsWith(BEAN_PREFIX)) {
            return this.flowServiceLocator.getTransitionCriteria(encodedCriteria.substring(BEAN_PREFIX.length()));
        }
        return this.createEventIdTransitionCriteria(encodedCriteria);
    }

    protected TransitionCriteria createEventIdTransitionCriteria(String eventId) throws ConversionException {
        return new EventIdTransitionCriteria(eventId);
    }

    protected TransitionCriteria createBooleanExpressionTransitionCriteria(Expression expression) throws ConversionException {
        return new BooleanExpressionTransitionCriteria(expression);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

