/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.builder;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.util.Assert;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.definition.registry.NoSuchFlowDefinitionException;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.builder.BaseFlowServiceLocator;
import org.springframework.webflow.engine.builder.FlowArtifactLookupException;

public class DefaultFlowServiceLocator
extends BaseFlowServiceLocator {
    private FlowDefinitionRegistry subflowRegistry;
    private BeanFactory beanFactory;
    static /* synthetic */ Class class$org$springframework$webflow$definition$registry$FlowDefinitionRegistry;
    static /* synthetic */ Class class$org$springframework$webflow$engine$Flow;

    public DefaultFlowServiceLocator(FlowDefinitionRegistry subflowRegistry, BeanFactory beanFactory) {
        Assert.notNull((Object)subflowRegistry, (String)"The subflow registry is required");
        Assert.notNull((Object)beanFactory, (String)"The bean factory is required");
        this.subflowRegistry = subflowRegistry;
        this.beanFactory = beanFactory;
    }

    public DefaultFlowServiceLocator(String subflowRegistryBeanId, BeanFactory beanFactory) {
        Assert.notNull((Object)subflowRegistryBeanId, (String)"The subflow registry bean id is required");
        Assert.notNull((Object)beanFactory, (String)"The bean factory is required");
        this.subflowRegistry = (FlowDefinitionRegistry)beanFactory.getBean(subflowRegistryBeanId, class$org$springframework$webflow$definition$registry$FlowDefinitionRegistry == null ? (class$org$springframework$webflow$definition$registry$FlowDefinitionRegistry = DefaultFlowServiceLocator.class$("org.springframework.webflow.definition.registry.FlowDefinitionRegistry")) : class$org$springframework$webflow$definition$registry$FlowDefinitionRegistry);
        this.beanFactory = beanFactory;
    }

    public Flow getSubflow(String id) throws FlowArtifactLookupException {
        try {
            return (Flow)this.subflowRegistry.getFlowDefinition(id);
        }
        catch (NoSuchFlowDefinitionException e) {
            throw new FlowArtifactLookupException(id, class$org$springframework$webflow$engine$Flow == null ? (class$org$springframework$webflow$engine$Flow = DefaultFlowServiceLocator.class$("org.springframework.webflow.engine.Flow")) : class$org$springframework$webflow$engine$Flow, "Could not locate subflow definition with id '" + id + "'", (Throwable)((Object)e));
        }
    }

    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    protected FlowDefinitionRegistry getSubflowRegistry() {
        return this.subflowRegistry;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

