# -*- coding: utf-8 -*-
# Generated by Django 1.9 on 2015-12-26 05:12
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Category',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=255, verbose_name='Title')),
                ('slug', models.CharField(blank=True, max_length=60, verbose_name='Slug')),
                ('description', models.TextField(blank=True, null=True, verbose_name='Description')),
                ('meta_title', models.CharField(blank=True, max_length=255, null=True, verbose_name='Meta title')),
                ('meta_keywords', models.CharField(blank=True, max_length=255, null=True, verbose_name='Meta keywords')),
                ('meta_description', models.CharField(blank=True, max_length=255, null=True, verbose_name='Meta description')),
            ],
            options={
                'ordering': ['title'],
                'verbose_name': 'Category',
                'verbose_name_plural': 'Categories',
            },
        ),
        migrations.CreateModel(
            name='Post',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=255, verbose_name='Title')),
                ('slug', models.CharField(blank=True, max_length=60, null=True, unique=True, verbose_name='Slug')),
                ('intro', models.TextField(blank=True, null=True, verbose_name='Intro')),
                ('content', models.TextField(verbose_name='Content')),
                ('origin', models.URLField(blank=True, null=True, verbose_name="Origin's url address")),
                ('published', models.BooleanField(default=False, verbose_name='Published')),
                ('pub_datetime', models.DateTimeField(default=django.utils.timezone.now, verbose_name='Created datetime')),
                ('last_modified', models.DateTimeField(auto_now=True, verbose_name='Last modified datetime')),
                ('meta_title', models.CharField(blank=True, max_length=255, null=True, verbose_name='Meta title')),
                ('meta_keywords', models.CharField(blank=True, max_length=255, null=True, verbose_name='Meta keywords')),
                ('meta_description', models.CharField(blank=True, max_length=255, null=True, verbose_name='Meta description')),
                ('author', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='Author')),
                ('category', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='news.Category', verbose_name='Category')),
            ],
            options={
                'ordering': ('-pub_datetime', 'title'),
                'verbose_name': 'News post',
                'verbose_name_plural': 'News posts',
            },
        ),
    ]
