# /********************************************************************************
# * Copyright © 2018-2019, ETH Zurich, D-BSSE, Andreas P. Cuny & Gotthold Fläschner
# * All rights reserved. This program and the accompanying materials
# * are made available under the terms of the GNU Public License v3.0
# * which accompanies this distribution, and is available at
# * http://www.gnu.org/licenses/gpl
# *
# * Contributors:
# *     Andreas P. Cuny - initial API and implementation
# *******************************************************************************/

import pandas as pd
from unittest import TestCase, main
from pyIMD.analysis.calculations import calculate_resonance_frequencies, calculate_position_correction, calculate_mass
from pyIMD.analysis.calculations import fit_function


class TestAnalysis(TestCase):

    def testCalculateResonanceFrequencies(self):

        expected_result = (73.00250958110351, [3.1824723379438966,  0.013685267232552985, -0.9999260252411822])
        frequency_array = pd.Series([42.998927506, 43.233302506, 43.467677506, 43.702052506, 43.936427506, 44.170802506,
                                     44.405177506, 44.639552506, 44.873927506, 45.108302506, 45.342677506, 45.577052506,
                                     45.811427506, 46.045802506, 46.280177506, 46.514552506, 46.748927506, 46.983302506,
                                     47.217677506, 47.452052506, 47.686427506, 47.920802506, 48.155177506, 48.389552506,
                                     48.623927506, 48.858302506, 49.092677506, 49.327052506, 49.561427506, 49.795802506,
                                     50.030177506, 50.264552506, 50.498927506, 50.733302506, 50.967677506, 51.202052506,
                                     51.436427506, 51.670802506, 51.905177506, 52.139552506, 52.373927506, 52.608302506,
                                     52.842677506, 53.077052506, 53.311427506, 53.545802506, 53.780177505999994,
                                     54.014552505999994, 54.248927505999994, 54.483302505999994, 54.717677505999994,
                                     54.952052505999994, 55.186427505999994, 55.420802505999994, 55.655177505999994,
                                     55.889552505999994, 56.123927505999994, 56.358302505999994, 56.592677505999994,
                                     56.827052505999994, 57.061427505999994, 57.295802505999994, 57.530177505999994,
                                     57.764552505999994, 57.998927505999994, 58.233302505999994, 58.467677505999994,
                                     58.702052505999994, 58.936427505999994, 59.170802505999994, 59.405177505999994,
                                     59.639552505999994, 59.873927505999994, 60.108302505999994, 60.342677505999994,
                                     60.577052505999994, 60.811427505999994, 61.045802505999994, 61.280177505999994,
                                     61.514552505999994, 61.748927505999994, 61.983302505999994, 62.217677505999994,
                                     62.452052505999994, 62.686427505999994, 62.920802505999994, 63.155177505999994,
                                     63.389552505999994, 63.623927505999994, 63.858302505999994, 64.09267750599999,
                                     64.32705250599999, 64.56142750599999, 64.79580250599999, 65.03017750599999,
                                     65.26455250599999, 65.49892750599999, 65.73330250599999, 65.96767750599999,
                                     66.20205250599999, 66.43642750599999, 66.67080250599999, 66.90517750599999,
                                     67.13955250599999, 67.37392750599999, 67.60830250599999, 67.84267750599999,
                                     68.07705250599999, 68.31142750599999, 68.54580250599999, 68.78017750599999,
                                     69.01455250599999, 69.24892750599999, 69.48330250599999, 69.71767750599999,
                                     69.95205250599999, 70.18642750599999, 70.42080250599999, 70.65517750599999,
                                     70.88955250599999, 71.12392750599999, 71.35830250599999, 71.59267750599999,
                                     71.82705250599999, 72.06142750599999, 72.29580250599999, 72.53017750599999,
                                     72.76455250599999, 72.99892750599999, 73.23330250599999, 73.46767750599999,
                                     73.70205250599999, 73.93642750599999, 74.17080250599999, 74.40517750599999,
                                     74.63955250599999, 74.87392750599999, 75.10830250599999, 75.34267750599999,
                                     75.57705250599999, 75.81142750599999, 76.04580250599999, 76.28017750599999,
                                     76.51455250599999, 76.74892750599999, 76.98330250599999, 77.21767750599999,
                                     77.45205250599999, 77.68642750599999, 77.92080250599999, 78.15517750599999,
                                     78.38955250599999, 78.62392750599999, 78.85830250599999, 79.09267750599999,
                                     79.32705250599999, 79.56142750599999, 79.79580250599999, 80.03017750599999,
                                     80.26455250599999, 80.49892750599999, 80.73330250599999, 80.96767750599999,
                                     81.20205250599999, 81.43642750599999, 81.67080250599999, 81.90517750599999,
                                     82.13955250599999, 82.37392750599999, 82.60830250599999, 82.84267750599999,
                                     83.07705250599999, 83.31142750599999, 83.54580250599999, 83.78017750599999,
                                     84.01455250599999, 84.24892750599999, 84.48330250599999, 84.71767750599999,
                                     84.95205250599999, 85.18642750599999, 85.42080250599999, 85.65517750599999,
                                     85.88955250599999, 86.12392750599999, 86.35830250599999, 86.59267750599999,
                                     86.82705250599999, 87.06142750599999, 87.29580250599999, 87.53017750599999,
                                     87.76455250599999, 87.99892750599999, 88.23330250599999, 88.46767750599999,
                                     88.70205250599999, 88.93642750599999, 89.17080250599999, 89.40517750599999,
                                     89.63955250599999, 89.87392750599999, 90.10830250599999, 90.34267750599999,
                                     90.57705250599999, 90.81142750599999, 91.04580250599999, 91.28017750599999,
                                     91.51455250599999, 91.74892750599999, 91.98330250599999, 92.21767750599999,
                                     92.45205250599999, 92.68642750599999, 92.92080250599999, 93.15517750599999,
                                     93.38955250599999, 93.62392750599999, 93.85830250599999, 94.09267750599999,
                                     94.32705250599999, 94.56142750599999, 94.79580250599999, 95.03017750599999,
                                     95.26455250599999, 95.49892750599999, 95.73330250599999, 95.96767750599999,
                                     96.20205250599999, 96.43642750599999, 96.67080250599999, 96.90517750599999,
                                     97.13955250599999, 97.37392750599999, 97.60830250599999, 97.84267750599999,
                                     98.07705250599999, 98.31142750599999, 98.54580250599999, 98.78017750599999,
                                     99.01455250599999, 99.24892750599999, 99.48330250599999, 99.71767750599999,
                                     99.95205250599999, 100.18642750599999, 100.42080250599999, 100.65517750599999,
                                     100.88955250599999, 101.12392750599999, 101.35830250599999, 101.59267750599999,
                                     101.82705250599999, 102.06142750599999, 102.29580250599999, 102.53017750599999,
                                     102.76455250599999])
        phase_array = pd.Series([-1.6861762652705063, -1.6576369982547994, -1.6843595113438046, -1.6637521815008727,
                                 -1.671739965095986, -1.6592652705061084, -1.647542757417103, -1.64587260034904,
                                 -1.6327678883071552, -1.6499197207678884, -1.6375776614310646, -1.6066160558464224,
                                 -1.620476439790576, -1.6231745200698082, -1.6233787085514835, -1.6066143106457242,
                                 -1.6165759162303666, -1.572567190226876, -1.580671902268761, -1.5921134380453752,
                                 -1.5521588132635253, -1.5717085514834206, -1.56034554973822, -1.5574136125654452,
                                 -1.5377905759162303, -1.52130017452007, -1.5330453752181503, -1.5243211169284467,
                                 -1.5416736474694592, -1.512952879581152, -1.5100087260034905, -1.4914153577661433,
                                 -1.4866160558464223, -1.5195130890052357, -1.4780279232111695, -1.4715043630017453,
                                 -1.4472356020942407, -1.440349040139616, -1.44082722513089, -1.4392547993019198,
                                 -1.4438376963350785, -1.413387434554974, -1.3816771378708552, -1.395762652705061,
                                 -1.3754240837696337, -1.3740314136125655, -1.3725130890052355, -1.3645881326352531,
                                 -1.3775514834205935, -1.3466858638743455, -1.3286143106457242, -1.3212268760907504,
                                 -1.3050244328097733, -1.2994502617801047, -1.3049197207678884, -1.2920034904013964,
                                 -1.283675392670157, -1.2679075043630017, -1.250973821989529, -1.2423176265270506,
                                 -1.207586387434555, -1.2203856893542757, -1.2199842931937175, -1.1946614310645725,
                                 -1.1952216404886562, -1.1768743455497384, -1.1839877835951136, -1.1529476439790578,
                                 -1.1222076788830715, -1.122240837696335, -1.117670157068063, -1.0977993019197207,
                                 -1.0866439790575917, -1.0854921465968588, -1.0450994764397907, -1.0816212914485166,
                                 -1.0458813263525306, -1.0199371727748692, -0.9859301919720769, -0.9988603839441536,
                                 -0.9883717277486911, -0.9584171029668412, -0.9525375218150087, -0.9158830715532287,
                                 -0.9258586387434555, -0.8840052356020943, -0.8769790575916231, -0.8682321116928446,
                                 -0.8321186736474695, -0.8408184991273997, -0.8169947643979059, -0.7942443280977313,
                                 -0.7960244328097732, -0.7664816753926702, -0.732631762652705, -0.7114153577661432,
                                 -0.702066317626527, -0.6969127399650961, -0.6786003490401397, -0.6603385689354276,
                                 -0.6182094240837697, -0.6171029668411867, -0.5814258289703316, -0.5765602094240838,
                                 -0.5643298429319372, -0.5303926701570681, -0.5051047120418848, -0.5097870855148342,
                                 -0.4750750436300175, -0.43205933682373476, -0.4150907504363002, -0.40664048865619545,
                                 -0.3846055846422339, -0.3409581151832461, -0.3034642233856894, -0.3262425828970332,
                                 -0.2992321116928447, -0.263912739965096, -0.24465095986038396, -0.21152006980802796,
                                 -0.17422024432809774, -0.1749755671902269, -0.1140366492146597, -0.10253961605584642,
                                 -0.11820000000000001, -0.07355514834205934, -0.028190052356020942,
                                 -0.023362478184991275, -0.009063141361256546, 0.04986910994764398, 0.08914572425828972,
                                 0.0891521815008726, 0.1053389179755672, 0.15261169284467715, 0.1253734729493892,
                                 0.18107329842931938, 0.21278359511343806, 0.2068150087260035, 0.2085741710296684,
                                 0.23557766143106457, 0.2826980802792321, 0.29120069808027926, 0.3551273996509599,
                                 0.3483403141361257, 0.3394799301919721, 0.38554450261780104, 0.37826527050610825,
                                 0.39290750436300176, 0.44656719022687613, 0.45501047120418847, 0.5019458987783596,
                                 0.5277469458987784, 0.5167068062827225, 0.5211256544502618, 0.5609895287958115,
                                 0.5782565445026178, 0.5713211169284468, 0.6081762652705062, 0.5979633507853404,
                                 0.638956369982548, 0.6459650959860385, 0.6578865619546248, 0.6767486910994766,
                                 0.7036352530541012, 0.7110331588132635, 0.748801047120419, 0.7605549738219896,
                                 0.7362251308900524, 0.7669319371727749, 0.7744834205933682, 0.7813577661431065,
                                 0.8532931937172775, 0.8395671902268761, 0.8833507853403142, 0.8630523560209424,
                                 0.862958115183246, 0.9027068062827225, 0.871432809773124, 0.9308115183246074,
                                 0.9158446771378709, 0.9454520069808028, 0.995301919720768, 0.9832338568935428,
                                 0.964977312390925, 0.9716509598603841, 1.0212862129144853, 0.9867242582897033,
                                 1.0112251308900524, 1.0165322862129147, 1.038040139616056, 1.0557120418848167,
                                 1.0713577661431066, 1.1023612565445027, 1.0358848167539267, 1.094561954624782,
                                 1.1134450261780107, 1.1220104712041885, 1.1254380453752182, 1.1190558464223386,
                                 1.1419650959860386, 1.1613734729493892, 1.1780715532286214, 1.1830471204188482,
                                 1.2069738219895287, 1.1769982547993019, 1.1761256544502618, 1.2253612565445027,
                                 1.2232966841186736, 1.2431815008726006, 1.2396858638743458, 1.2244712041884818,
                                 1.244998254799302, 1.294324607329843, 1.2496649214659687, 1.2440069808027923,
                                 1.2882687609075045, 1.3039895287958114, 1.3110383944153579, 1.3125794066317629,
                                 1.32817277486911, 1.2894223385689354, 1.3239860383944155, 1.3217975567190228,
                                 1.3096195462478186, 1.3418394415357766, 1.375171029668412, 1.3673106457242585,
                                 1.384413612565445, 1.3922530541012217, 1.3797958115183246, 1.4157940663176265,
                                 1.3985462478184993, 1.4124345549738222, 1.4057853403141363, 1.4259563699825482,
                                 1.4291989528795812, 1.4351396160558465, 1.5194240837696336, 1.456935427574171,
                                 1.4720331588132636, 1.4888551483420596, 1.453453752181501, 1.4711832460732985,
                                 1.449130890052356, 1.5066125654450264, 1.5187382198952881, 1.4918446771378708,
                                 1.5092670157068062, 1.5322547993019198, 1.5559965095986041, 1.4883193717277488,
                                 1.521712041884817, 1.5433595113438046, 1.6019650959860383, 1.5392792321116928,
                                 1.5761431064572426])
        initial_param_guess = [70.0, 2.0, 0.5, 0]
        lower_param_bounds = [10.0, 1.0, -0.5, -1.0]
        upper_param_bounds = [80.0, 5.0, 1, 1.0]

        result = calculate_resonance_frequencies(frequency_array, phase_array, initial_param_guess, lower_param_bounds,
                                                 upper_param_bounds)
        self.assertEqual(result[0], expected_result[0])
        self.assertEqual(result[1][0], expected_result[1][0])
        self.assertEqual(result[1][1], expected_result[1][1])
        self.assertEqual(result[1][2], expected_result[1][2])

    def testFitFunction(self):

        self.assertEqual(fit_function(1, 1, 1, 0, 0), 0.0)
        self.assertEqual(fit_function(1, 1, 1, 1, 1), 2)
        self.assertEqual(fit_function(10, 10, 10, 10, 10), 110)

    def testCalculatePositionCorrection(self):
        expected_result = 1.153459551762745
        cell_position = 5
        cantilever_length = 100
        ret = calculate_position_correction(cell_position, cantilever_length)

        self.assertEqual(ret, expected_result)

    def testCalculateMass(self):
        expected_result = 1.6659296417966238
        spring_constant = 4
        res_freq_before_cell_load = 73.00250958110351
        res_freq_after_cell_load = 70
        ret = calculate_mass(spring_constant, res_freq_after_cell_load, res_freq_before_cell_load)

        self.assertEqual(ret, expected_result)


if __name__ == "__main__":
    main()


