# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class RemediationDeployment(Model):
    """Details of a single deployment created by the remediation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar remediated_resource_id: Resource ID of the resource that is being
     remediated by the deployment.
    :vartype remediated_resource_id: str
    :ivar deployment_id: Resource ID of the template deployment that will
     remediate the resource.
    :vartype deployment_id: str
    :ivar status: Status of the remediation deployment.
    :vartype status: str
    :ivar resource_location: Location of the resource that is being
     remediated.
    :vartype resource_location: str
    :ivar error: Error encountered while remediated the resource.
    :vartype error: ~azure.mgmt.policyinsights.models.ErrorDefinition
    :ivar created_on: The time at which the remediation was created.
    :vartype created_on: datetime
    :ivar last_updated_on: The time at which the remediation deployment was
     last updated.
    :vartype last_updated_on: datetime
    """

    _validation = {
        'remediated_resource_id': {'readonly': True},
        'deployment_id': {'readonly': True},
        'status': {'readonly': True},
        'resource_location': {'readonly': True},
        'error': {'readonly': True},
        'created_on': {'readonly': True},
        'last_updated_on': {'readonly': True},
    }

    _attribute_map = {
        'remediated_resource_id': {'key': 'remediatedResourceId', 'type': 'str'},
        'deployment_id': {'key': 'deploymentId', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'resource_location': {'key': 'resourceLocation', 'type': 'str'},
        'error': {'key': 'error', 'type': 'ErrorDefinition'},
        'created_on': {'key': 'createdOn', 'type': 'iso-8601'},
        'last_updated_on': {'key': 'lastUpdatedOn', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs) -> None:
        super(RemediationDeployment, self).__init__(**kwargs)
        self.remediated_resource_id = None
        self.deployment_id = None
        self.status = None
        self.resource_location = None
        self.error = None
        self.created_on = None
        self.last_updated_on = None
