# -*- coding: utf-8 -*-
import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models


class Migration(SchemaMigration):

    def forwards(self, orm):
        # Adding model 'DeploymentLogEntry'
        db.create_table('deployment_deploymentlogentry', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('type', self.gf('django.db.models.fields.CharField')(max_length=50)),
            ('time', self.gf('django.db.models.fields.DateTimeField')(auto_now_add=True, blank=True)),
            ('user', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['auth.User'])),
            ('message', self.gf('django.db.models.fields.TextField')()),
        ))
        db.send_create_signal('server', ['DeploymentLogEntry'])

        # Adding model 'ConfigIngredient'
        db.create_table('deployment_configingredient', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('name', self.gf('django.db.models.fields.CharField')(unique=True, max_length=50)),
            ('config_yaml', self.gf('vr.server.fields.YAMLDictField')(null=True, blank=True)),
            ('env_yaml', self.gf('vr.server.fields.YAMLDictField')(null=True, blank=True)),
        ))
        db.send_create_signal('server', ['ConfigIngredient'])

        # Adding model 'BuildPack'
        db.create_table('deployment_buildpack', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('repo_url', self.gf('django.db.models.fields.CharField')(unique=True, max_length=200)),
            ('repo_type', self.gf('django.db.models.fields.CharField')(default='git', max_length=10)),
            ('desc', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('order', self.gf('django.db.models.fields.IntegerField')()),
        ))
        db.send_create_signal('server', ['BuildPack'])

        # Adding model 'App'
        db.create_table('deployment_app', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('name', self.gf('django.db.models.fields.CharField')(unique=True, max_length=50)),
            ('repo_url', self.gf('django.db.models.fields.CharField')(max_length=200)),
            ('repo_type', self.gf('django.db.models.fields.CharField')(max_length=10)),
            ('buildpack', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['server.BuildPack'], null=True, blank=True)),
        ))
        db.send_create_signal('server', ['App'])

        # Adding model 'Tag'
        db.create_table('deployment_tag', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('app', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['server.App'])),
            ('name', self.gf('django.db.models.fields.CharField')(max_length=20)),
        ))
        db.send_create_signal('server', ['Tag'])

        # Adding model 'Build'
        db.create_table('deployment_build', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('app', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['server.App'])),
            ('tag', self.gf('django.db.models.fields.CharField')(max_length=50)),
            ('file', self.gf('django.db.models.fields.files.FileField')(max_length=100, null=True, blank=True)),
            ('start_time', self.gf('django.db.models.fields.DateTimeField')(null=True)),
            ('end_time', self.gf('django.db.models.fields.DateTimeField')(null=True)),
            ('status', self.gf('django.db.models.fields.CharField')(default='pending', max_length=20)),
            ('hash', self.gf('django.db.models.fields.CharField')(max_length=32, null=True, blank=True)),
            ('env_yaml', self.gf('vr.server.fields.YAMLDictField')(null=True, blank=True)),
            ('buildpack_url', self.gf('django.db.models.fields.CharField')(max_length=200, null=True, blank=True)),
            ('buildpack_version', self.gf('django.db.models.fields.CharField')(max_length=50, null=True, blank=True)),
        ))
        db.send_create_signal('server', ['Build'])

        # Adding model 'Release'
        db.create_table('deployment_release', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('build', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['server.Build'])),
            ('config_yaml', self.gf('vr.server.fields.YAMLDictField')(null=True, blank=True)),
            ('env_yaml', self.gf('vr.server.fields.YAMLDictField')(null=True, blank=True)),
            ('hash', self.gf('django.db.models.fields.CharField')(max_length=32, null=True, blank=True)),
        ))
        db.send_create_signal('server', ['Release'])

        # Adding model 'Host'
        db.create_table('deployment_host', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('name', self.gf('django.db.models.fields.CharField')(unique=True, max_length=200)),
            ('active', self.gf('django.db.models.fields.BooleanField')(default=True)),
            ('squad', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='hosts', null=True, to=orm['server.Squad'])),
        ))
        db.send_create_signal('server', ['Host'])

        # Adding model 'Squad'
        db.create_table('deployment_squad', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('name', self.gf('django.db.models.fields.CharField')(unique=True, max_length=50)),
        ))
        db.send_create_signal('server', ['Squad'])

        # Adding model 'Swarm'
        db.create_table('deployment_swarm', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('app', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['server.App'], null=True)),
            ('release', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['server.Release'])),
            ('config_name', self.gf('django.db.models.fields.CharField')(max_length=50)),
            ('proc_name', self.gf('django.db.models.fields.CharField')(max_length=50)),
            ('squad', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['server.Squad'])),
            ('size', self.gf('django.db.models.fields.IntegerField')(default=1)),
            ('pool', self.gf('django.db.models.fields.CharField')(max_length=50, null=True, blank=True)),
            ('balancer', self.gf('django.db.models.fields.CharField')(max_length=50, null=True, blank=True)),
            ('config_yaml', self.gf('vr.server.fields.YAMLDictField')(null=True, blank=True)),
            ('env_yaml', self.gf('vr.server.fields.YAMLDictField')(null=True, blank=True)),
        ))
        db.send_create_signal('server', ['Swarm'])

        # Adding unique constraint on 'Swarm', fields ['app', 'config_name', 'squad', 'proc_name']
        db.create_unique('deployment_swarm', ['app_id', 'config_name', 'squad_id', 'proc_name'])

        # Adding M2M table for field config_ingredients on 'Swarm'
        db.create_table('deployment_swarm_config_ingredients', (
            ('id', models.AutoField(verbose_name='ID', primary_key=True, auto_created=True)),
            ('swarm', models.ForeignKey(orm['server.swarm'], null=False)),
            ('configingredient', models.ForeignKey(orm['server.configingredient'], null=False))
        ))
        db.create_unique('deployment_swarm_config_ingredients', ['swarm_id', 'configingredient_id'])

        # Adding model 'PortLock'
        db.create_table('deployment_portlock', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('host', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['server.Host'])),
            ('port', self.gf('django.db.models.fields.IntegerField')()),
            ('created_time', self.gf('django.db.models.fields.DateTimeField')(auto_now_add=True, blank=True)),
        ))
        db.send_create_signal('server', ['PortLock'])

        # Adding unique constraint on 'PortLock', fields ['host', 'port']
        db.create_unique('deployment_portlock', ['host_id', 'port'])

        # Adding model 'TestRun'
        db.create_table('deployment_testrun', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('start', self.gf('django.db.models.fields.DateTimeField')()),
            ('end', self.gf('django.db.models.fields.DateTimeField')(null=True)),
        ))
        db.send_create_signal('server', ['TestRun'])

        # Adding model 'TestResult'
        db.create_table('deployment_testresult', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('run', self.gf('django.db.models.fields.related.ForeignKey')(related_name='tests', to=orm['server.TestRun'])),
            ('time', self.gf('django.db.models.fields.DateTimeField')()),
            ('hostname', self.gf('django.db.models.fields.CharField')(max_length=200)),
            ('procname', self.gf('django.db.models.fields.CharField')(max_length=200)),
            ('passed', self.gf('django.db.models.fields.BooleanField')(default=False)),
            ('testcount', self.gf('django.db.models.fields.IntegerField')(default=0)),
            ('results', self.gf('django.db.models.fields.TextField')()),
        ))
        db.send_create_signal('server', ['TestResult'])


    def backwards(self, orm):
        # Removing unique constraint on 'PortLock', fields ['host', 'port']
        db.delete_unique('deployment_portlock', ['host_id', 'port'])

        # Removing unique constraint on 'Swarm', fields ['app', 'config_name', 'squad', 'proc_name']
        db.delete_unique('deployment_swarm', ['app_id', 'config_name', 'squad_id', 'proc_name'])

        # Deleting model 'DeploymentLogEntry'
        db.delete_table('deployment_deploymentlogentry')

        # Deleting model 'ConfigIngredient'
        db.delete_table('deployment_configingredient')

        # Deleting model 'BuildPack'
        db.delete_table('deployment_buildpack')

        # Deleting model 'App'
        db.delete_table('deployment_app')

        # Deleting model 'Tag'
        db.delete_table('deployment_tag')

        # Deleting model 'Build'
        db.delete_table('deployment_build')

        # Deleting model 'Release'
        db.delete_table('deployment_release')

        # Deleting model 'Host'
        db.delete_table('deployment_host')

        # Deleting model 'Squad'
        db.delete_table('deployment_squad')

        # Deleting model 'Swarm'
        db.delete_table('deployment_swarm')

        # Removing M2M table for field config_ingredients on 'Swarm'
        db.delete_table('deployment_swarm_config_ingredients')

        # Deleting model 'PortLock'
        db.delete_table('deployment_portlock')

        # Deleting model 'TestRun'
        db.delete_table('deployment_testrun')

        # Deleting model 'TestResult'
        db.delete_table('deployment_testresult')


    models = {
        'auth.group': {
            'Meta': {'object_name': 'Group'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '80'}),
            'permissions': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['auth.Permission']", 'symmetrical': 'False', 'blank': 'True'})
        },
        'auth.permission': {
            'Meta': {'ordering': "('content_type__app_label', 'content_type__model', 'codename')", 'unique_together': "(('content_type', 'codename'),)", 'object_name': 'Permission'},
            'codename': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'content_type': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['contenttypes.ContentType']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '50'})
        },
        'auth.user': {
            'Meta': {'object_name': 'User'},
            'date_joined': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now'}),
            'email': ('django.db.models.fields.EmailField', [], {'max_length': '75', 'blank': 'True'}),
            'first_name': ('django.db.models.fields.CharField', [], {'max_length': '30', 'blank': 'True'}),
            'groups': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['auth.Group']", 'symmetrical': 'False', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'is_active': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'is_staff': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_superuser': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'last_login': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now'}),
            'last_name': ('django.db.models.fields.CharField', [], {'max_length': '30', 'blank': 'True'}),
            'password': ('django.db.models.fields.CharField', [], {'max_length': '128'}),
            'user_permissions': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['auth.Permission']", 'symmetrical': 'False', 'blank': 'True'}),
            'username': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '30'})
        },
        'contenttypes.contenttype': {
            'Meta': {'ordering': "('name',)", 'unique_together': "(('app_label', 'model'),)", 'object_name': 'ContentType', 'db_table': "'django_content_type'"},
            'app_label': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'model': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '100'})
        },
        'server.app': {
            'Meta': {'ordering': "('name',)", 'object_name': 'App', 'db_table': "'deployment_app'"},
            'buildpack': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['server.BuildPack']", 'null': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '50'}),
            'repo_type': ('django.db.models.fields.CharField', [], {'max_length': '10'}),
            'repo_url': ('django.db.models.fields.CharField', [], {'max_length': '200'})
        },
        'server.build': {
            'Meta': {'ordering': "['-id']", 'object_name': 'Build', 'db_table': "'deployment_build'"},
            'app': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['server.App']"}),
            'buildpack_url': ('django.db.models.fields.CharField', [], {'max_length': '200', 'null': 'True', 'blank': 'True'}),
            'buildpack_version': ('django.db.models.fields.CharField', [], {'max_length': '50', 'null': 'True', 'blank': 'True'}),
            'end_time': ('django.db.models.fields.DateTimeField', [], {'null': 'True'}),
            'env_yaml': ('vr.server.fields.YAMLDictField', [], {'null': 'True', 'blank': 'True'}),
            'file': ('django.db.models.fields.files.FileField', [], {'max_length': '100', 'null': 'True', 'blank': 'True'}),
            'hash': ('django.db.models.fields.CharField', [], {'max_length': '32', 'null': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'start_time': ('django.db.models.fields.DateTimeField', [], {'null': 'True'}),
            'status': ('django.db.models.fields.CharField', [], {'default': "'pending'", 'max_length': '20'}),
            'tag': ('django.db.models.fields.CharField', [], {'max_length': '50'})
        },
        'server.buildpack': {
            'Meta': {'ordering': "['order']", 'object_name': 'BuildPack', 'db_table': "'deployment_buildpack'"},
            'desc': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'order': ('django.db.models.fields.IntegerField', [], {}),
            'repo_type': ('django.db.models.fields.CharField', [], {'default': "'git'", 'max_length': '10'}),
            'repo_url': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '200'})
        },
        'server.configingredient': {
            'Meta': {'ordering': "['name']", 'object_name': 'ConfigIngredient', 'db_table': "'deployment_configingredient'"},
            'config_yaml': ('vr.server.fields.YAMLDictField', [], {'null': 'True', 'blank': 'True'}),
            'env_yaml': ('vr.server.fields.YAMLDictField', [], {'null': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '50'})
        },
        'server.deploymentlogentry': {
            'Meta': {'ordering': "['-time']", 'object_name': 'DeploymentLogEntry', 'db_table': "'deployment_deploymentlogentry'"},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'message': ('django.db.models.fields.TextField', [], {}),
            'time': ('django.db.models.fields.DateTimeField', [], {'auto_now_add': 'True', 'blank': 'True'}),
            'type': ('django.db.models.fields.CharField', [], {'max_length': '50'}),
            'user': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['auth.User']"})
        },
        'server.host': {
            'Meta': {'ordering': "('name',)", 'object_name': 'Host', 'db_table': "'deployment_host'"},
            'active': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '200'}),
            'squad': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'hosts'", 'null': 'True', 'to': "orm['server.Squad']"})
        },
        'server.portlock': {
            'Meta': {'unique_together': "(('host', 'port'),)", 'object_name': 'PortLock', 'db_table': "'deployment_portlock'"},
            'created_time': ('django.db.models.fields.DateTimeField', [], {'auto_now_add': 'True', 'blank': 'True'}),
            'host': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['server.Host']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'port': ('django.db.models.fields.IntegerField', [], {})
        },
        'server.release': {
            'Meta': {'ordering': "['-id']", 'object_name': 'Release', 'db_table': "'deployment_release'"},
            'build': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['server.Build']"}),
            'config_yaml': ('vr.server.fields.YAMLDictField', [], {'null': 'True', 'blank': 'True'}),
            'env_yaml': ('vr.server.fields.YAMLDictField', [], {'null': 'True', 'blank': 'True'}),
            'hash': ('django.db.models.fields.CharField', [], {'max_length': '32', 'null': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'})
        },
        'server.squad': {
            'Meta': {'ordering': "('name',)", 'object_name': 'Squad', 'db_table': "'deployment_squad'"},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '50'})
        },
        'server.swarm': {
            'Meta': {'ordering': "['app__name', 'config_name', 'proc_name']", 'unique_together': "(('app', 'config_name', 'squad', 'proc_name'),)", 'object_name': 'Swarm', 'db_table': "'deployment_swarm'"},
            'app': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['server.App']", 'null': 'True'}),
            'balancer': ('django.db.models.fields.CharField', [], {'max_length': '50', 'null': 'True', 'blank': 'True'}),
            'config_ingredients': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['server.ConfigIngredient']", 'symmetrical': 'False', 'blank': 'True'}),
            'config_name': ('django.db.models.fields.CharField', [], {'max_length': '50'}),
            'config_yaml': ('vr.server.fields.YAMLDictField', [], {'null': 'True', 'blank': 'True'}),
            'env_yaml': ('vr.server.fields.YAMLDictField', [], {'null': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'pool': ('django.db.models.fields.CharField', [], {'max_length': '50', 'null': 'True', 'blank': 'True'}),
            'proc_name': ('django.db.models.fields.CharField', [], {'max_length': '50'}),
            'release': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['server.Release']"}),
            'size': ('django.db.models.fields.IntegerField', [], {'default': '1'}),
            'squad': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['server.Squad']"})
        },
        'server.tag': {
            'Meta': {'object_name': 'Tag', 'db_table': "'deployment_tag'"},
            'app': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['server.App']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '20'})
        },
        'server.testresult': {
            'Meta': {'object_name': 'TestResult', 'db_table': "'deployment_testresult'"},
            'hostname': ('django.db.models.fields.CharField', [], {'max_length': '200'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'passed': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'procname': ('django.db.models.fields.CharField', [], {'max_length': '200'}),
            'results': ('django.db.models.fields.TextField', [], {}),
            'run': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'tests'", 'to': "orm['server.TestRun']"}),
            'testcount': ('django.db.models.fields.IntegerField', [], {'default': '0'}),
            'time': ('django.db.models.fields.DateTimeField', [], {})
        },
        'server.testrun': {
            'Meta': {'ordering': "['-start']", 'object_name': 'TestRun', 'db_table': "'deployment_testrun'"},
            'end': ('django.db.models.fields.DateTimeField', [], {'null': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'start': ('django.db.models.fields.DateTimeField', [], {})
        }
    }

    complete_apps = ['server']