# -*- coding: utf-8 -*-

################################################################
# zopyx.plone.smashdocs
# (C) 2016,  Andreas Jung, www.zopyx.com, Tuebingen, Germany
################################################################

from zope import schema
from zope.interface import implements
from zope.interface import implementer
from plone.dexterity.content import Container
from plone.supermodel import model

from .i18n import MessageFactory as _


class ISmashDocument(model.Schema):

    creator_id = schema.TextLine(
        title=_(u'SMASHDOCs creator id'),
        default=None,
        readonly=True,
        required=False)

    document_id = schema.TextLine(
        title=_(u'SMASHDOCs document id'),
        default=None,
        readonly=True,
        required=False)

    subtitle = schema.TextLine(
        title=_(u'SMASHDOCs subtitle'), default=u'', required=False)

    footer = schema.TextLine(
        title=_(u'SMASHDOCs footer'), default=u'', required=False)

    group_id = schema.TextLine(
        title=_(u'SMASHDOCs group id'),
        #        default=u'default',
        required=False)


@implementer(ISmashDocument)
class SmashDocument(Container):
    def computed_group_id(self):

        group_id = self.group_id
        if group_id:
            return group_id

        parent = self.aq_parent
        if parent.portal_type == 'SmashFolder':
            return parent.group_id
        raise ValueError('Could not compute SMASHDOCs group_id')
