#!/usr/bin/python3
# -*- coding: utf-8 -*-
#
# Author:  Dominik Gresch <greschd@gmx.ch>
# Date:    15.10.2014 14:49:25 CEST
# File:    tb_hamilton.py

import sys
sys.path.insert(0, '../')
import z2pack

from common import *

import unittest


class TbHamiltonTestCase(CommonTestCase):

    def testH(self):
        H = z2pack.tb.Hamilton()

        # create the two atoms
        H.add_atom(([1, 1], 1), [0, 0, 0])
        H.add_atom(([-1, -1, 3], 1), [0.5, 0.6, 0.2])

        # add hopping between different atoms
        H.add_hopping(((0, 0), (1, 2)),
                      z2pack.tb.vectors.combine([0, -1], [0, -1], 0),
                      0.1,
                      phase=[1, -1j, 1j, -1])
        H.add_hopping(((0, 1), (1, 0)),
                      z2pack.tb.vectors.combine([0, -1], [0, -1], 0),
                      0.7,
                      phase=[1, 1j, -1j, -1])

        # add hopping between neighbouring orbitals of the same type
        H.add_hopping((((0, 0), (0, 0)), ((0, 1), (0, 1))),
                      z2pack.tb.vectors.neighbours([0, 1], forward_only=True),
                      -0.3,
                      phase=[1])
        H.add_hopping((((1, 1), (1, 1)), ((1, 0), (1, 0))),
                      z2pack.tb.vectors.neighbours([0, 1], forward_only=True),
                      -0.8,
                      phase=[1])
        H.add_hopping((((1, 1), (1, 1)), ((1, 0), (1, 0))),
                      [[1, 2, 3]],
                      -0.9,
                      phase=[1])
        M = [[[(0.993008295596571-0.071954987974492568j), 0j], [0j, (0.99348173534855022-0.11399140989054064j)]], [[(0.96910188670687414-0.086406043580308026j), 0j], [0j, (0.99348173534855022-0.11399140989054064j)]], [[(0.98935329598064303-0.093324204238993472j), 0j], [0j, (0.99348173534855022-0.11399140989054064j)]], [[(0.96577502905553425-0.07480942480037861j), 0j], [0j, (0.99348173534855022-0.11399140989054064j)]], [[(0.97025688780916453-0.074041880865667237j), 0j], [0j, (0.99348173534855022-0.11399140989054064j)]], [[(0.98680948391602752-0.092504282867847329j), 0j], [0j, (0.99348173534855022-0.11399140989054064j)]], [[(0.97292458589629505-0.087831809501483019j), 0j], [0j, (0.99348173534855022-0.11399140989054064j)]], [[(0.98963053173185722-0.072166593246609331j), 0j], [0j, (0.99348173534855022-0.11399140989054064j)]], [[(0.95736003460556962-0.079156098215642068j), 0j], [0j, (0.99348173534855022-0.11399140989054064j)]], [[(0.99450317249413778-0.094980379304426432j), 0j], [0j, (0.99348173534855022-0.11399140989054064j)]], [[(0.95805146413919762-0.080518670653202409j), 0j], [0j, (0.99348173534855022-0.11399140989054064j)]]]

        self.assertContainerAlmostEqual(H._getM([0.4, 0, 0], [0.4, 0, 1], 12), M)

if __name__ == "__main__":
    unittest.main()
