# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class PurchaseRequest(Model):
    """PurchaseRequest.

    :param sku:
    :type sku: ~azure.mgmt.reservations.models.SkuName
    :param location: The Azure Region where the reserved resource lives.
    :type location: str
    :param reserved_resource_type: Possible values include: 'VirtualMachines',
     'SqlDatabases', 'SuseLinux', 'CosmosDb'
    :type reserved_resource_type: str or
     ~azure.mgmt.reservations.models.ReservedResourceType
    :param billing_scope_id:
    :type billing_scope_id: str
    :param term: Possible values include: 'P1Y', 'P3Y'
    :type term: str or ~azure.mgmt.reservations.models.ReservationTerm
    :param quantity:
    :type quantity: int
    :param display_name: Friendly name of the Reservation
    :type display_name: str
    :param applied_scope_type: Possible values include: 'Single', 'Shared'
    :type applied_scope_type: str or
     ~azure.mgmt.reservations.models.AppliedScopeType
    :param applied_scopes:
    :type applied_scopes: list[str]
    :param reserved_resource_properties: Properties specific to each reserved
     resource type. Not required if not applicable.
    :type reserved_resource_properties:
     ~azure.mgmt.reservations.models.PurchaseRequestPropertiesReservedResourceProperties
    """

    _attribute_map = {
        'sku': {'key': 'sku', 'type': 'SkuName'},
        'location': {'key': 'location', 'type': 'str'},
        'reserved_resource_type': {'key': 'properties.reservedResourceType', 'type': 'str'},
        'billing_scope_id': {'key': 'properties.billingScopeId', 'type': 'str'},
        'term': {'key': 'properties.term', 'type': 'str'},
        'quantity': {'key': 'properties.quantity', 'type': 'int'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'applied_scope_type': {'key': 'properties.appliedScopeType', 'type': 'str'},
        'applied_scopes': {'key': 'properties.appliedScopes', 'type': '[str]'},
        'reserved_resource_properties': {'key': 'properties.reservedResourceProperties', 'type': 'PurchaseRequestPropertiesReservedResourceProperties'},
    }

    def __init__(self, *, sku=None, location: str=None, reserved_resource_type=None, billing_scope_id: str=None, term=None, quantity: int=None, display_name: str=None, applied_scope_type=None, applied_scopes=None, reserved_resource_properties=None, **kwargs) -> None:
        super(PurchaseRequest, self).__init__(**kwargs)
        self.sku = sku
        self.location = location
        self.reserved_resource_type = reserved_resource_type
        self.billing_scope_id = billing_scope_id
        self.term = term
        self.quantity = quantity
        self.display_name = display_name
        self.applied_scope_type = applied_scope_type
        self.applied_scopes = applied_scopes
        self.reserved_resource_properties = reserved_resource_properties
