# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class CalculatePriceResponseProperties(Model):
    """CalculatePriceResponseProperties.

    :param billing_currency_total: Currency and amount that customer will be
     charged in customer's local currency. Tax is not included.
    :type billing_currency_total:
     ~azure.mgmt.reservations.models.CalculatePriceResponsePropertiesBillingCurrencyTotal
    :param is_billing_partner_managed: True if billing is managed by Microsoft
     Partner. Used only for CSP accounts.
    :type is_billing_partner_managed: bool
    :param reservation_order_id: GUID that represents reservation order that
     can be placed after calculating price.
    :type reservation_order_id: str
    :param sku_title: Title of SKU that is being purchased.
    :type sku_title: str
    :param sku_description: Description of SKU that is being purchased.
    :type sku_description: str
    :param pricing_currency_total: Amount that Microsoft uses for record. Used
     during refund for calculating refund limit. Tax is not included.
    :type pricing_currency_total:
     ~azure.mgmt.reservations.models.CalculatePriceResponsePropertiesPricingCurrencyTotal
    """

    _attribute_map = {
        'billing_currency_total': {'key': 'billingCurrencyTotal', 'type': 'CalculatePriceResponsePropertiesBillingCurrencyTotal'},
        'is_billing_partner_managed': {'key': 'isBillingPartnerManaged', 'type': 'bool'},
        'reservation_order_id': {'key': 'reservationOrderId', 'type': 'str'},
        'sku_title': {'key': 'skuTitle', 'type': 'str'},
        'sku_description': {'key': 'skuDescription', 'type': 'str'},
        'pricing_currency_total': {'key': 'pricingCurrencyTotal', 'type': 'CalculatePriceResponsePropertiesPricingCurrencyTotal'},
    }

    def __init__(self, *, billing_currency_total=None, is_billing_partner_managed: bool=None, reservation_order_id: str=None, sku_title: str=None, sku_description: str=None, pricing_currency_total=None, **kwargs) -> None:
        super(CalculatePriceResponseProperties, self).__init__(**kwargs)
        self.billing_currency_total = billing_currency_total
        self.is_billing_partner_managed = is_billing_partner_managed
        self.reservation_order_id = reservation_order_id
        self.sku_title = sku_title
        self.sku_description = sku_description
        self.pricing_currency_total = pricing_currency_total
