########################################################################
# test/xslt/oc_20001122.py
# Olivier Cayrol <olivier.cayrol@logilab.fr> reports xsl:text bug
# See 
# https://sourceforge.net/bugs/?func=detailbug&bug_id=123172&group_id=6473

import os
import cStringIO
import unittest

from amara.lib import treecompare
from amara.test import test_main
from amara.test.xslt import xslt_test, filesource, stringsource

class test_xslt_xsl_text_oc_20001122(xslt_test):
    source = stringsource("""\
<?xml version="1.0" standalone="yes"?> 

                            <!DOCTYPE addressbook > 

                            <addressbook> 
                            <entry> 
                            <firstname>Alexandre</firstname> 
                            <lastname>FAYOLLE</lastname> 
                            </entry> 
                            <entry> 
                            <firstname>Nicolas</firstname> 
                            <lastname>CHAUVAT</lastname> 
                            </entry> 
                            </addressbook>""")
    transform = stringsource("""\
<?xml version="1.0" encoding="ISO-8859-1" standalone="yes" ?> 

                            <xsl:stylesheet 
                            xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                            version="1.0" 
                            > 

                            <xsl:output method="html" encoding="ISO-8859-1"/> 

                            <xsl:template match="/"> 
                            <html> 
                            <head> 
                            <title>Address Book Test</title> 
                            </head> 
                            <body> 
                            <xsl:apply-templates/> 
                            </body> 
                            </html> 
                            </xsl:template> 
                            <xsl:template match="addressbook"> 
                            <p>My friends are: 
                            <ul> 
                            <xsl:apply-templates/> 
                            </ul> 
                            </p> 
                            </xsl:template> 

                            <xsl:template match="entry"> 
                            <li> 
                            <xsl:value-of select="firstname"/><xsl:text> </xsl:text> 
                            <xsl:value-of select="lastname"/> 
                            </li> 
                            </xsl:template> 

                            </xsl:stylesheet>""")
    parameters = {}
    expected = """\
<html>
  <head>
    <meta http-equiv='Content-Type' content='text/html; charset=ISO-8859-1'>
    <title>Address Book Test</title>
  </head>
  <body>
    <p>My friends are: 
                            <ul>
        <li>Alexandre FAYOLLE</li>
        <li>Nicolas CHAUVAT</li>
      </ul>
    </p>
  </body>
</html>"""


if __name__ == '__main__':
    test_main()
